﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


#include <nn/util/util_BitFlagSet.h>
#include <nn/os/os_Mutex.h>
#include <nn/audio/audio_Common.h>

namespace nn { namespace audio { namespace common {

class NodeIdManager
{
private:
    NodeIdManager(); // this class is static class.

public:
    enum class NodeIdType : uint8_t
    {
        Voice = 1,
        Mix = 2,
        Sink = 3,

        Invalid = 0xff,
    };

    static const int TypeWidth = 4;
    static const int BaseWidth = 12;
    static const int VariationWidth = 16;
    static const int TypeShift = BaseWidth + VariationWidth;
    static const int BaseShift = VariationWidth;
    static const int VariationShift = 0;
    static const int TypeMax = (1 << TypeWidth) - 1;
    static const int BaseMax = (1 << BaseWidth) - 1;
    static const int VariationMax = (1 << VariationWidth) - 1;

    static NodeId GetNodeId(NodeIdType type, int base, int variation) NN_NOEXCEPT;
    static NodeIdType GetType(NodeId nodeId) NN_NOEXCEPT;
    static int GetBase(NodeId nodeId) NN_NOEXCEPT;
    static int GetVariation(NodeId nodeId) NN_NOEXCEPT;
    static NodeId GetInvalidNodeId() NN_NOEXCEPT;
};

}}} // namespace nn::audio::common
