﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/util/util_BitUtil.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/os/os_Mutex.h>

#include <nn/audio/audio_Common.h>
#include <nn/audio/audio_FinalOutputRecorderApi.h>

#include "common/audio_Util.h"

namespace nn {
namespace audio {

NN_DEFINE_STATIC_CONSTANT( const size_t FinalOutputRecorderBuffer::AddressAlignment );
NN_DEFINE_STATIC_CONSTANT( const size_t FinalOutputRecorderBuffer::SizeGranularity );

template <>
void FinalOutputRecorderBufferList::clear() NN_NOEXCEPT
{
    pHead = pTail = nullptr;
}

template <>
void FinalOutputRecorderBufferList::push_back(FinalOutputRecorderBuffer* p) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(p);
    NN_SDK_REQUIRES_NOT_NULL(p->buffer);
    if (!pHead)
    {
        NN_SDK_ASSERT(pTail == nullptr);
        pHead = pTail = p;
    }
    else
    {
        NN_SDK_ASSERT_NOT_NULL(pTail);
        pTail->pNext = p;
        pTail = p;
    }
    p->pNext = nullptr;
    p->offset = 0;
}

template <>
void FinalOutputRecorderBufferList::pop_front() NN_NOEXCEPT
{
    FinalOutputRecorderBuffer* p = pHead;
    if (p)
    {
        pHead = p->pNext;
        if (pHead == nullptr)
        {
            pTail = nullptr;
        }
    }
}

template <>
FinalOutputRecorderBuffer* FinalOutputRecorderBufferList::front() const NN_NOEXCEPT
{
    return pHead;
}

template <>
FinalOutputRecorderBuffer* FinalOutputRecorderBufferList::back() const NN_NOEXCEPT
{
    return pTail;
}

}  // namespace audio
}  // namespace nn
