﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/audio/audio_AudioRendererTypes.h>
#include <nn/audio/detail/audio_AudioRendererTypesInternal.h>

namespace nn { namespace audio { namespace detail {

inline detail::AudioRendererParameterInternal ConvertToAudioRendererParameterInternal(const AudioRendererParameter& parameter) NN_NOEXCEPT
{
    detail::AudioRendererParameterInternal parameterInternal = {};

    parameterInternal.sampleRate = parameter.sampleRate;
    parameterInternal.sampleCount = parameter.sampleCount;
    parameterInternal.mixBufferCount = parameter.mixBufferCount;
    parameterInternal.subMixCount = parameter.subMixCount;
    parameterInternal.voiceCount = parameter.voiceCount;
    parameterInternal.sinkCount = parameter.sinkCount;
    parameterInternal.effectCount = parameter.effectCount;
    parameterInternal.performanceFrameCount = parameter.performanceFrameCount;
    parameterInternal.isVoiceDropEnabled = parameter.isVoiceDropEnabled;
    parameterInternal.splitterCount = parameter.splitterCount;
    parameterInternal.splitterSendChannelCount = parameter.splitterSendChannelCount;
    parameterInternal.renderingDevice = static_cast<int8_t>(parameter.renderingDevice);
    parameterInternal.executionMode = static_cast<int8_t>(parameter.executionMode);
    parameterInternal.bufferSizeForAudioCodec = parameter._extra;
    parameterInternal._magic = parameter._magic;

    return parameterInternal;
}

}}} // namespace nn::audio::detail
