﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn
{
    [CppRefPath(@"<nn/nn_ApplicationId.h>")]
    [ExternalStruct(8, 8)]
    public struct ApplicationId {}
}

namespace nn.os
{
    [CppRefPath(@"<nn/os/os_Types.h>")]
    [ExternalStruct(8, 8)]
    public struct ProcessId {}
}

namespace nn.ns
{
    [CppRefPath(@"<nn/ns/ns_ApplicationManagerApi.h>")]
    [ExternalStruct(16384, 8)]
    [LargeData(true)]
    public struct ApplicationControlProperty{}
}

namespace nn.arp
{
    [CppRefPath(@"<nn/arp/arp_Types.h>")]
    [ExternalStruct(16, 8)]
    public struct ApplicationLaunchProperty{}
}

namespace nn.arp.detail
{
    public interface IWriter : IServiceObject
    {
        [MethodId(0)]
        Result AcquireRegistrar(Out<IRegistrar> pOut);

        [MethodId(1)]
        Result DeleteProperties(os.ProcessId pid);
    }

    public interface IReader : IServiceObject
    {
        [MethodId(0)]
        Result GetApplicationLaunchProperty(Out<ApplicationLaunchProperty> pOut, os.ProcessId pid);

        [MethodId(1)]
        Result GetApplicationLaunchPropertyWithApplicationId(Out<ApplicationLaunchProperty> pOut, ApplicationId applicationId);

        [MethodId(2)]
        Result GetApplicationControlProperty([BufferTransferMode(BufferTransferMode.MapAlias)] Out<ns.ApplicationControlProperty> pOut, os.ProcessId pid);

        [MethodId(3)]
        Result GetApplicationControlPropertyWithApplicationId([BufferTransferMode(BufferTransferMode.MapAlias)] Out<ns.ApplicationControlProperty> pOut, ApplicationId applicationId);
    }

    public interface IRegistrar : IServiceObject
    {
        [MethodId(0)]
        Result Issue(os.ProcessId pid);

        [MethodId(1)]
        Result SetApplicationLaunchProperty(ApplicationLaunchProperty launchProp);

        [MethodId(2)]
        Result SetApplicationControlProperty([BufferTransferMode(BufferTransferMode.MapAlias)] ns.ApplicationControlProperty ctrlProp);
    }
}
