﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Base.h>
#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Abort.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/am/am_Shim.h>
#include <nn/am/service/am_CommonTypes.h>
#include <nn/applet/applet_InternalFunctions.h>

namespace nn { namespace applet {

// キャストして am に直渡しできるようにしておく
NN_STATIC_ASSERT( WirelessPriorityMode_OptimizedForBluetooth == static_cast<WirelessPriorityMode>(am::service::WirelessPriorityMode_OptimizedForBluetooth) );
NN_STATIC_ASSERT( WirelessPriorityMode_OptimizedForWlan == static_cast<WirelessPriorityMode>(am::service::WirelessPriorityMode_OptimizedForWlan) );

void SetWirelessPriorityMode(WirelessPriorityMode mode) NN_NOEXCEPT
{
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    NN_ABORT_UNLESS_RESULT_SUCCESS(am::GetSelfController()->SetWirelessPriorityMode(static_cast<int>(mode)));
#else
    NN_UNUSED(mode);
#endif
}

}}
