﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.apm
{
    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/apm/apm_Types.h>")]
    public struct PerformanceMode
    {
    }

    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/apm/apm_Types.h>")]
    public struct PerformanceConfiguration
    {
    }

    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/apm/apm_SystemTypes.h>")]
    public struct EventTarget
    {
    }

    [ExternalStruct(40, 8)]
    [CppRefPath(@"<nn/apm/apm_SystemTypes.h>")]
    public struct ThrottlingState
    {
    }

    // アプリケーションの保持する Session。
    // アプリケーション終了時に破棄する為 ManagedObject で取得する必要がある。
    [CppRefPath("<nn/apm/apm_ISession.sfdl.h>")]
    interface ISession : IServiceObject
    {
        [MethodId(0)]
        Result SetPerformanceConfiguration(PerformanceMode performanceMode, PerformanceConfiguration performanceConfiguration);

        [MethodId(1)]
        Result GetPerformanceConfiguration(Out<PerformanceConfiguration> pOutPerformanceConfiguration, PerformanceMode performanceMode);
    }

    // アプリケーション向けの Manager。
    [CppRefPath("<nn/apm/apm_IManager.sfdl.h>")]
    interface IManager : IServiceObject
    {
        [MethodId(0)]
        Result OpenSession(Out<ISession> pOutSession);

        [MethodId(1)]
        Result GetPerformanceMode(Out<PerformanceMode> pOutPerformanceMode);
    }

    // システム/テスト向けの Manager。
    [CppRefPath("<nn/apm/apm_ISystemManager.sfdl.h>")]
    interface ISystemManager : IServiceObject
    {
        [MethodId(0)]
        Result RequestPerformanceMode(PerformanceMode performanceMode);

        [MethodId(1)]
        Result GetPerformanceEvent(Out<NativeHandle> pOutNativeHandle, EventTarget eventTarget);

        [MethodId(2)]
        Result GetThrottlingState(Out<ThrottlingState> pOutThrottlingState);

        [MethodId(3)]
        Result GetLastThrottlingState(Out<ThrottlingState> pOutThrottlingState);

        [MethodId(4)]
        Result ClearLastThrottlingState();

        [MethodId(5)]
        Result LoadAndApplySettings();
   }

    // アプリケーション向けの Manager。
    [CppRefPath("<nn/apm/apm_IManagerPrivileged.sfdl.h>")]
    interface IManagerPrivileged : IServiceObject
    {
        [MethodId(0)]
        Result OpenSession(Out<ISession> pOutSession);
    }
}
