﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/apm/apm_ISession.sfdl.h> // for ISession
#include <nn/sf/sf_Types.h> // for nn::sf::SharedPointer

namespace nn { namespace apm {

class SessionDataContainer
{
public:
    SessionDataContainer() NN_NOEXCEPT
    {
    }

    void Backup(nn::sf::SharedPointer<nn::apm::ISession>& session) NN_NOEXCEPT
    {
        NN_UNUSED(session);
    }

    void Restore(nn::sf::SharedPointer<nn::apm::ISession>& session) NN_NOEXCEPT
    {
        NN_UNUSED(session);
    }
};

}} // namespace nn::apm
