﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/apm/apm_Types.h>
#include <nn/apm/apm_SystemTypes.h>
#include "apm_SessionImpl.h"

namespace nn { namespace apm { namespace server {

//! @name APM サーバでセッションが使用する関数
//! @{

void AddSessionToList(Session* pSession) NN_NOEXCEPT;
void RemoveSessionFromList(Session* pSession) NN_NOEXCEPT;
void UpdatePerformance() NN_NOEXCEPT;
bool GetBatteryDrainingEnabled() NN_NOEXCEPT;

// バックグラウンド時の設定値とともに別ファイルで管理するべきかもしれない。
PerformanceConfiguration GetDefaultPerformanceConfiguration(PerformanceMode performanceMode) NN_NOEXCEPT;

//! @}

//! @name APM ライブラリの API に対応する関数
//! @{

void RequestPerformanceMode(PerformanceMode performanceMode) NN_NOEXCEPT;
PerformanceMode GetPerformanceMode() NN_NOEXCEPT;
void GetEventPtr(nn::os::SystemEventType** pOutEventPtr, nn::apm::EventTarget target) NN_NOEXCEPT;
void GetThrottlingState(ThrottlingState* pOutThrottlingState) NN_NOEXCEPT;
void GetLastThrottlingState(ThrottlingState* pOutThrottlingState) NN_NOEXCEPT;
void ClearLastThrottlingState() NN_NOEXCEPT;
void LoadAndApplySettings() NN_NOEXCEPT;

//! @}

}}} // namespace nn::apm::server
