﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.am.service
{
    [CppRefPath(Location.FunctionsSfdlPath)]
    public interface IOverlayFunctions : IServiceObject
    {
        /// <summary>
        /// HOME ボタン短押しのメッセージ監視を開始する
        /// </summary>
        /// <returns>
        /// </returns>
        /// <remarks>
        /// 通常は SA にのみ通知される Message_DetectShortPressingHomeButton を
        /// オーバーレイプロセスが横取りするのを開始します。
        /// </remarks>
        [MethodId(0)]
        Result BeginToWatchShortHomeButtonMessage();

        /// <summary>
        /// HOME ボタン短押しのメッセージ監視を終了する
        /// </summary>
        /// <returns>
        /// </returns>
        /// <remarks>
        /// オーバーレイプロセスが横取りしていた
        /// Message_DetectShortPressingHomeButton の通知を終了します。
        /// これ以降、このメッセージは再度 SA に対して通知されます。
        /// </remarks>
        [MethodId(1)]
        Result EndToWatchShortHomeButtonMessage();

        [MethodId(2)]
        Result GetApplicationIdForLogo(Out<ncm.ApplicationId> pOut);

        [MethodId(3)]
        Result SetGpuTimeSliceBoost(uint64_t nanoSeconds);

        /// <summary>
        /// OA で設定した APD 設定値の有効無効を設定する
        /// </summary>
        /// <returns>
        /// </returns>
        /// </remarks>
        [MethodId(4)]
        Result SetAutoSleepTimeAndDimmingTimeEnabled(bool isEnabled);

        [MethodId(5)]
        Result TerminateApplicationAndSetReason(uint32_t result);

        /// <summary>
        /// グローバルなスクリーンショット撮影の禁止と許可
        /// </summary>
        /// <returns>
        /// </returns>
        /// </remarks>
        [MethodId(6)]
        Result SetScreenShotPermissionGlobally(bool isPermitted);

        /// <summary>
        /// ボタン操作の監視を開始する
        /// </summary>
        /// <returns>
        /// </returns>
        /// <remarks>
        /// オーバーレイプロセスが hid の入力を受け取るようになります。
        /// この機能は開発用機能として OA が hid 入力を表示するために使用します。
        /// BeginToWatchShortHomeButtonMessage または EndToWatchShortHomeButtonMessage の呼出により終了します。
        ///
        /// BeginToWatchShortHomeButtonMessage と異なり以下の状態になります。
        /// - Message_DetectShortPressingHomeButton は OA に通知されません。
        /// - hid 入力は OA によって独占されず、下位のアプレットも受け取ります。
        /// </remarks>
        [MethodId(101)]
        Result BeginToObserveHidInputForDevelop();

    }

    [CppRefPath(Location.ProxiesSfdlPath)]
    public interface IOverlayAppletProxy : IStackableAppletProxy
    {
        [MethodId(20)]
        Result GetOverlayFunctions(Out<IOverlayFunctions> pOut);
    }
}
