﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.ncm
{
    [CppRefPath(@"<nn/ncm/ncm_StorageId.h>")]
    [ExternalStruct(1, 1)]
    public struct StorageId
    {
    }
}

namespace nn.ns
{
    [CppRefPath(@"<nn/ns/ns_ApplicationControlDataApi.h>")]
    [ExternalStruct(16384, 8)]
    [LargeData(true)]
    public struct ApplicationControlProperty
    {
    }
}

namespace nn.err
{
    [CppRefPath("<nn/err/err_Types.h>")]
    [ExternalStruct(8, 4)]
    public struct ErrorCode
    {
    }

    [CppRefPath("<nn/err/err_ErrorContext.h>")]
    [ExternalStruct(512, 8)]
    [LargeData(true)]
    public struct ErrorContext
    {
    }
}

namespace nn.am.service
{
    [CppRefPath(Location.CommonTypesPath)]
    [ExternalStruct(8, 4)]
    public struct LibraryAppletInfo
    {
    }

    /// <summary>
    /// ライブラリアプレットプロセスから AM 内のオブジェクトへのアクセッサ
    /// </summary>
    [CppRefPath(Location.FunctionsSfdlPath)]
    public interface ILibraryAppletSelfAccessor : IServiceObject
    {
        /// <summary>
        /// メモリ領域を呼び出し元から取得する
        /// </summary>
        /// <param name="storage"></param>
        /// <returns></returns>
        [MethodId(0)]
        Result PopInData(Out<IStorage> pOut);

        /// <summary>
        /// メモリ領域を呼び出し元に転送する
        /// </summary>
        /// <param name="storage"></param>
        /// <returns></returns>
        [MethodId(1)]
        Result PushOutData(IStorage storage);

        /// <summary>
        /// メモリ領域を呼び出し元から取得する
        /// </summary>
        /// <param name="storage"></param>
        /// <returns></returns>
        [MethodId(2)]
        Result PopInteractiveInData(Out<IStorage> pOut);

        /// <summary>
        /// メモリ領域を呼び出し元に転送する
        /// </summary>
        /// <param name="storage"></param>
        /// <returns></returns>
        [MethodId(3)]
        Result PushInteractiveOutData(IStorage storage);

        [MethodId(5)]
        Result GetPopInDataEvent(Out<NativeHandle> pOut);

        [MethodId(6)]
        Result GetPopInteractiveInDataEvent(Out<NativeHandle> pOut);

        /// <summary>
        /// ライブラリアプレットが使用できるストレージを取得する
        /// </summary>
        /// <param name="storage"></param>
        /// <returns>ILibraryAppletAccessor.SetExtraStorage を取得する</returns>
        [MethodId(20)]
        Result PopExtraStorage(Out<IStorage> pStorage);

        [MethodId(25)]
        Result GetPopExtraStorageEvent(Out<NativeHandle> pOut);

        [MethodId(30)]
        Result UnpopInData(IStorage storage);

        [MethodId(31)]
        Result UnpopExtraStorage(IStorage storage);

        /// <summary>
        /// 自身を終了する
        /// </summary>
        /// <returns></returns>
        /// <remarks>
        /// 以下を行う。
        /// - この呼び出しを返す (この呼び出しが返った後は、無限スリープすることを想定)
        /// - 以下を非同期に行う
        /// - プロセスを終了する
        /// - 自身を WaitingForPop にする
        /// </remarks>
        [MethodId(10)]
        Result ExitProcessAndReturn();

        [MethodId(11)]
        Result GetLibraryAppletInfo(Out<LibraryAppletInfo> pOut);

        [MethodId(12)]
        Result GetMainAppletIdentityInfo(Out<AppletIdentityInfo> pOut);

        [MethodId(13)]
        Result CanUseApplicationCore(Out<bool> pOut);

        [MethodId(14)]
        Result GetCallerAppletIdentityInfo(Out<AppletIdentityInfo> pOut);

        [MethodId(15)]
        Result GetMainAppletApplicationControlProperty([BufferTransferMode(BufferTransferMode.MapAlias)] Out<ns.ApplicationControlProperty> pOut);

        [MethodId(16)]
        Result GetMainAppletStorageId(Out<nn.ncm.StorageId> pOut);

        [MethodId(17)]
        Result GetCallerAppletIdentityInfoStack(Out<int> pOutCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<AppletIdentityInfo> pOutList);

        [MethodId(18)]
        Result GetNextReturnDestinationAppletIdentityInfo(Out<AppletIdentityInfo> pOut);

        [MethodId(19)]
        Result GetDesirableKeyboardLayout(Out<Bit32> pOutLayout);

        [MethodId(40)]
        Result GetIndirectLayerProducerHandle(Out<vi.IndirectProducerHandleType> pOut);

        [MethodId(50)]
        Result ReportVisibleError(nn.err.ErrorCode errorCode);

        [MethodId(51)]
        Result ReportVisibleErrorWithErrorContext(nn.err.ErrorCode errorCode, [BufferTransferMode(BufferTransferMode.MapAlias)] nn.err.ErrorContext errorContext);

        [MethodId(60)]
        Result GetMainAppletApplicationDesiredLanguage(Out<nn.settings.LanguageCode> pOut);

        /// <summary>
        /// applicationId のアプリケーションを作成し、
        /// pStorage を LaunchParameterKind_Application で push し、
        /// SA にアプリ起動リクエストを送る
        /// </summary>
        /// <returns></returns>
        [MethodId(90)]
        Result CreateApplicationAndPushAndRequestToLaunch(ncm.ApplicationId applicationId, IStorage pStorage);

        [MethodId(100)]
        Result CreateGameMovieTrimmer(Out<grcsrv.IGameMovieTrimmer> pOut, NativeHandle workMemoryHandle, uint64_t workMemorySize);

        [MethodId(101)]
        Result ReserveResourceForMovieOperation();

        [MethodId(102)]
        Result UnreserveResourceForMovieOperation();
    }

    [CppRefPath(Location.ProxiesSfdlPath)]
    public interface ILibraryAppletProxy : IStackableAppletProxy
    {
        [MethodId(20)]
        Result OpenLibraryAppletSelfAccessor(Out<ILibraryAppletSelfAccessor> pOut);
    }
}
