﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/am/service/display/am_ScreenShotOperation.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/capsrv/capsrv_Result.h>
#include <nn/capsrv/capsrv_ScreenShotControl.h>
#include <nn/capsrv/capsrv_SystemReservedInfo.h>

namespace nn{ namespace am{ namespace service{ namespace display{

    nn::Result ScreenShotOperation::RequestTakingScreenShot(
        nn::os::Tick tick,
        nn::ncm::ApplicationId applicationId,
        nn::applet::AppletResourceUserId aruid,
        const nn::capsrv::ScreenShotAttribute& attribute,
        const nn::capsrv::UserIdList& userIdList,
        nn::TimeSpan timeout
    ) NN_NOEXCEPT
    {
        int64_t seq = tick.GetInt64Value();
        if(seq <= 0)
        {
            seq = 1;
        }

        return nn::capsrv::RequestTakingScreenShot(
            seq,
            { applicationId.value },
            aruid,
            attribute,
            userIdList,
            timeout
        );
    }

    nn::Result ScreenShotOperation::CancelTakingScreenShotAsNoTarget(nn::os::Tick tick) NN_NOEXCEPT
    {
        int64_t seq = tick.GetInt64Value();
        if(seq < 0)
        {
            seq = 0;
        }

        return nn::capsrv::CancelTakingScreenShot(seq, nn::capsrv::ResultInternalScreenShotCanceledAsNoTarget());
    }

    nn::Result ScreenShotOperation::CancelTakingScreenShotAsProhibited(nn::os::Tick tick) NN_NOEXCEPT
    {
        int64_t seq = tick.GetInt64Value();
        if(seq < 0)
        {
            seq = 0;
        }

        return nn::capsrv::CancelTakingScreenShot(seq, nn::capsrv::ResultInternalScreenShotCanceledAsProhibited());
    }

    nn::Result ScreenShotOperation::NotifyScreenShotRefused(nn::os::Tick tick, nn::ncm::ApplicationId applicationId, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    {
        NN_UNUSED(tick);
        NN_UNUSED(aruid);
        return nn::capsrv::NotifyTakingScreenShotRefused({ applicationId.value });
    }

    nn::Result ScreenShotOperation::NotifyScreenShotFailed(nn::os::Tick tick, nn::ncm::ApplicationId applicationId, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    {
        NN_UNUSED(tick);
        NN_UNUSED(aruid);
        return nn::capsrv::NotifyTakingScreenShotFailed({ applicationId.value });
    }
}}}}

