﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/am/service/am_OverlayNotificationControl.h>

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/am/service/am_ServiceDiagnostics.h>

#include <nn/ovln/ovln_SenderForOverlay.h>
#include <nn/ovln/ovln_FormatForOverlay.h>

namespace nn { namespace am { namespace service {

namespace {

bool g_Enabled = false;
nn::ovln::SenderForOverlayType g_SenderForOverlayNotificationOfBlockingHomeButton;

Result InitializeOverlayNotificationImpl() NN_NOEXCEPT
{
    NN_RESULT_DO(ovln::InitializeSenderLibraryForOverlay());
    NN_RESULT_DO(ovln::InitializeSenderForValue(&g_SenderForOverlayNotificationOfBlockingHomeButton));
    NN_RESULT_SUCCESS;
}

}

void InitializeOverlayNotification() NN_NOEXCEPT
{
    auto result = InitializeOverlayNotificationImpl();
    if (!result.IsSuccess())
    {
        NN_AM_SERVICE_LOG(error, "InitializeOverlayNotification failed: result = %08x\n", result.GetInnerValueForDebug());
    }
    g_Enabled = result.IsSuccess();
}

void SendOverlayNotificationOfBlockingHomeButtonShortPressed() NN_NOEXCEPT
{
    if (g_Enabled)
    {
        ovln::Message message = {};
        message.tag = ovln::format::HomeButtonIsNotPermittedDataTag;
        ovln::Send(&g_SenderForOverlayNotificationOfBlockingHomeButton, message);
    }
}

void SendOverlayNotificationOfBlockingHomeButtonLongPressed() NN_NOEXCEPT
{
    if (g_Enabled)
    {
        ovln::Message message = {};
        message.tag = ovln::format::HomeButtonLongPressedIsNotPermittedDataTag;
        ovln::Send(&g_SenderForOverlayNotificationOfBlockingHomeButton, message);
    }
}

void SendOverlayNotificationOfContinuousRecordingNotEnabled() NN_NOEXCEPT
{
    if (g_Enabled)
    {
        ovln::Message message = {};
        message.tag = ovln::format::ContinuousRecordingNotEnabledDataTag;
        ovln::Send(&g_SenderForOverlayNotificationOfBlockingHomeButton, message);
    }
}

void SendOverlayNotificationOfContinuousRecordingNotPermitted() NN_NOEXCEPT
{
    if (g_Enabled)
    {
        ovln::Message message = {};
        message.tag = ovln::format::ContinuousRecordingNotPermittedDataTag;
        ovln::Send(&g_SenderForOverlayNotificationOfBlockingHomeButton, message);
    }
}

}}}
