﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_HipcClientProxyByName.h> // for nn::sf::CreateHipcProxyByName
#include <nn/sf/sf_ExpHeapAllocator.h> // for nn::sf::ExpHeapStaticAllocator
#include <nn/nn_Abort.h>
#include "ahid_CreateClient.h"

namespace nn {
namespace ahid {

namespace{

struct CreateClientByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreateClientByHipcTag> MyAllocator;

class MyAllocatorInitializer
{
public:

    MyAllocatorInitializer() NN_NOEXCEPT
    {
        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }

} g_MyAllocatorInitializer;

};

Result CreateClientByHipc(nn::sf::SharedPointer<IServerSession> *pServerSession, const char* pServicePath) NN_NOEXCEPT
{
    return nn::sf::CreateHipcProxyByName<IServerSession, MyAllocator::Policy>(pServerSession, pServicePath);
}

}   // namespace ahid
}   // namespace nn
