﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.ahid.hdr
{
    [CppRefPath(@"<nn/ahid/hdr/hdr_Types.h>")]
    [ExternalStruct(4, 4)]
    public struct DeviceHandle{}

    [CppRefPath(@"<nn/ahid/hdr/sfdl/ISession.sfdl.h>")]
    public interface ISession : IServiceObject
    {
        [MethodId(0)]
        Result GetDeviceEntries(Out<uint32_t> pEntries);

        [MethodId(1)]
        Result GetDeviceList(Out<uint32_t> pOutEntries, uint32_t entries, nn.sf.OutBuffer outDeviceHandles, nn.sf.InBuffer inAttachFilter);

        [MethodId(2)]
        Result GetDeviceParameters(DeviceHandle handle, nn.sf.OutBuffer outDeviceParameters);

        [MethodId(3)]
        Result AttachDevice(nn.sf.InBuffer inDeviceParameters, Out<DeviceHandle> outHandle);

        [MethodId(4)]
        Result DetachDevice(DeviceHandle handle);

        [MethodId(5)]
        Result SetDeviceFilterForHipc(nn.sf.InBuffer inDeviceFilter, uint32_t entries);
    }
}
