﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/account/ndas/account_AuthenticationCache.h>

#include "../detail/account_CacheUtil.h"

#include <mutex>

#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace account { namespace ndas {

bool ApplicationAuthenticationCacheOperator::IsExpired(int64_t expiration) NN_NOEXCEPT
{
    return detail::CacheUtil::IsExpiredInUptime<detail::Hour<1>::sec>(expiration);
}
void ApplicationAuthenticationCacheOperator::DeleteCacheData(const std::pair<detail::Uuid, ApplicationMeta>& data, const detail::AbstractLocalStorage& storage) NN_NOEXCEPT
{
    detail::CacheUtil::DeleteCacheFile(data.first, storage);
}

/* --------------------------------------------------------------------------------------------
    ApplicationAuthenticationCache
 */
Result ApplicationAuthenticationCache::Load(size_t* pOutActualSize, char* outToken, size_t bufferSize, const detail::ApplicationInfo& appInfo) const NN_NOEXCEPT
{
    NN_SDK_ASSERT(pOutActualSize);
    NN_SDK_ASSERT(outToken);
    NN_SDK_ASSERT(bufferSize >= detail::NdasAppAuthTokenSizeMax);
    std::lock_guard<decltype(*this)> lock(*this);

    DataType data;
    NN_RESULT_DO(FindUnsafe(&data, appInfo));
    return detail::CacheUtil::LoadCacheFile<detail::NdasAppAuthTokenSizeMax, ResultNdasTokenLengthUnacceptable>(
        pOutActualSize, outToken, bufferSize, data.first, GetStorageRef());
}
Result ApplicationAuthenticationCache::GetMeta(ApplicationMeta* pOutMeta, const detail::ApplicationInfo& appInfo) const NN_NOEXCEPT
{
    NN_SDK_ASSERT(pOutMeta);
    std::lock_guard<decltype(*this)> lock(*this);

    DataType data;
    NN_RESULT_DO(FindUnsafe(&data, appInfo));
    *pOutMeta = data.second;
    NN_RESULT_SUCCESS;
}

}}} // ~namespace nn::account::ndas
