﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/account/nas/account_NasTypes.h>

#include "../http/account_OAuthUtil.h"

namespace nn {
namespace account {
namespace nas {

bool Scope::IsValid() const NN_NOEXCEPT
{
    return http::IsValidScope(data, sizeof(data));
}
bool State::IsValid() const NN_NOEXCEPT
{
    return http::IsValidState(data, sizeof(data));
}
bool Nonce::IsValid() const NN_NOEXCEPT
{
    return http::IsValidNonce(data, sizeof(data));
}

} // ~namespace nn::account::nas
}
}
