﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/baas/account_BaasLoginCache.h>

#include <nn/nn_Result.h>

namespace nn { namespace account { namespace baas {

const char AuthorizationLead[] = "Authorization: Bearer ";
const size_t RequiredBufferSizeForAuthorizationHeader = sizeof(AuthorizationLead) + detail::BaasAccessTokenSizeMax;

Result CreateAuthorizationHeaderWithClientAccessToken(char* buffer, size_t bufferSize, const ClientAccessTokenCache& clientAccessTokenCache) NN_NOEXCEPT;
Result CreateAuthorizationHeaderWithUserAccessToken(char* buffer, size_t bufferSize, const UserAccessTokenCache& userAccessTokenCache, const NetworkServiceAccountId& user) NN_NOEXCEPT;

}}}
