﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "account_BaasAuthorizationHeader.h"

#include <nn/account/baas/account_BaasLoginCache.h>
#include <nn/account/detail/account_InternalConfig.h>
#include <nn/account/account_ResultPrivate.h>

#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace account { namespace baas {

Result CreateAuthorizationHeaderWithClientAccessToken(char* buffer, size_t bufferSize, const ClientAccessTokenCache& clientAccessTokenCache) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(buffer != nullptr);
    NN_SDK_REQUIRES(bufferSize >= RequiredBufferSizeForAuthorizationHeader);

    // Authorization ヘッダの準備
    auto offset = sizeof(AuthorizationLead) - 1;
    NN_SDK_ASSERT(bufferSize > offset);
    std::memcpy(buffer , AuthorizationLead, offset);

    // public_client アクセストークンの取得
    size_t clientAccessTokenSizeActual;
    NN_RESULT_DO(clientAccessTokenCache.Load(
        &clientAccessTokenSizeActual, buffer + offset, bufferSize - offset));
    offset += clientAccessTokenSizeActual;
    NN_SDK_ASSERT(bufferSize > offset);

    NN_RESULT_THROW_UNLESS(offset + 1 < bufferSize, ResultInsufficientBuffer());
    buffer[offset] = '\0';
    NN_SDK_ASSERT(strnlen(buffer, bufferSize) == offset);
    NN_RESULT_SUCCESS;
}

Result CreateAuthorizationHeaderWithUserAccessToken(char* buffer, size_t bufferSize, const UserAccessTokenCache& userAccessTokenCache, const NetworkServiceAccountId& user) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(buffer != nullptr);
    NN_SDK_REQUIRES(bufferSize >= RequiredBufferSizeForAuthorizationHeader);

    // Authorization ヘッダの準備
    auto offset = sizeof(AuthorizationLead) - 1;
    NN_SDK_ASSERT(bufferSize > offset);
    std::memcpy(buffer , AuthorizationLead, offset);

    // public_user アクセストークンの取得
    size_t userAccessTokenSizeActual;
    NN_RESULT_DO(userAccessTokenCache.Load(
        &userAccessTokenSizeActual, buffer + offset, bufferSize - offset, user));
    offset += userAccessTokenSizeActual;
    NN_SDK_ASSERT(bufferSize > offset);

    NN_RESULT_THROW_UNLESS(offset + 1 <= bufferSize, ResultInsufficientBuffer());
    buffer[offset] = '\0';
    NN_SDK_ASSERT(strnlen(buffer, bufferSize) == offset);
    NN_RESULT_SUCCESS;
}

}}}

