﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

/**
 * デバッグ用ユーティリティ
 */

#include <nn/nn_SdkLog.h>

//#define NN_TMP451_DEBUG

#ifdef NN_TMP451_DEBUG
#define NN_TMP451_LOG(fmt, ...) NN_SDK_LOG("nnd::tmp451 > %s(%d)\t: " fmt, __FUNCTION__, __LINE__, ##__VA_ARGS__ )
#define NN_TMP451_LOG_DETAIL(fmt, ...) NN_SDK_LOG("nnd::tmp451::detail > %s(%d)\t: " fmt, __FUNCTION__, __LINE__, ##__VA_ARGS__ )
#else
#define NN_TMP451_LOG(...)
#define NN_TMP451_LOG_DETAIL(...)
#endif
namespace nnd {
namespace tmp451 {
namespace detail {

inline void PrintCurrentState(MeasurementMode mode) NN_NOEXCEPT
{
    switch (mode)
    {
    case MeasurementMode::Continuous:
        {
            NN_TMP451_LOG_DETAIL("Current mode: Continuous\n");
        }
        break;
    case MeasurementMode::OneShot:
        {
            NN_TMP451_LOG_DETAIL("Current mode: OneShot\n");
        }
        break;
    case MeasurementMode::Standby:
        {
            NN_TMP451_LOG_DETAIL("Current mode: Standby\n");
        }
        break;
    default: NN_UNEXPECTED_DEFAULT;
    }
}


} // detail
} // tmp451
} // nnd
