﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

/**
 * バスに関する定義
 */

#include <nn/TargetConfigs/build_Base.h>

#include <nn/gpio/gpio.h>
#include <nn/i2c/i2c.h>

namespace nnd {
namespace tmp451 {
namespace detail {

const nn::i2c::TransactionOption    I2cTransStop        = nn::i2c::TransactionOption_StopCondition;
const nn::i2c::TransactionOption    I2cTransStart       = nn::i2c::TransactionOption_StartCondition;
const nn::i2c::TransactionOption    I2cTransStartStop   = static_cast<nn::i2c::TransactionOption>(
                                                            nn::i2c::TransactionOption_StartCondition
                                                          | nn::i2c::TransactionOption_StopCondition);

const nn::gpio::InterruptMode       GpioInterruptMode   = nn::gpio::InterruptMode::InterruptMode_FallingEdge;

} // detail
} // ftm3bd56
} // nnd
