﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/i2c/driver/i2c_DriverService.h>

#include <nnd/i2c/tegra/i2cTegra.h>

#include "detail/i2cTegra_BusPowerManager.h"
#include "detail/i2cTegra_DeviceCodeNodeParser.h"
#include "detail/i2cTegra_I2cBusAccessorManager.h"
#include "detail/i2cTegra_I2cDevicePropertyManager.h"
#include "detail/i2cTegra_TargetSpec.h"

namespace {

nnd::i2c::tegra::detail::I2cBusAccessorManager<nnd::i2c::tegra::detail::MaxBuses> g_I2cBusAccessorManager;
nnd::i2c::tegra::detail::I2cDevicePropertyManager<nnd::i2c::tegra::detail::MaxDevices> g_I2cDevicePropertyManager;

// 将来的にはデバイスツリーから取得した PCV の電源制御対象および依存するバスの識別子で初期化したい
nnd::i2c::tegra::detail::BusPowerManager g_BusPowerManager;

nnd::i2c::tegra::detail::DeviceCodeBusParser g_DeviceCodeBusParser(
    g_I2cBusAccessorManager.GetAllocator(),
    &g_BusPowerManager);

nnd::i2c::tegra::detail::DeviceCodeDeviceParser g_DeviceCodeDeviceParser(
    g_I2cBusAccessorManager.GetAllocator(),
    g_I2cDevicePropertyManager.GetAllocator(),
    &g_BusPowerManager);

}

namespace nnd { namespace i2c { namespace tegra {

void Initialize() NN_NOEXCEPT
{
    nn::i2c::driver::RegisterDeviceCodeNodeParser(&g_DeviceCodeBusParser);
    nn::i2c::driver::RegisterDeviceCodeNodeParser(&g_DeviceCodeDeviceParser);
}

}}} // nnd::i2c::tegra
