﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>

#include <nn/util/util_IntrusiveList.h>

#include <nn/i2c/driver/i2c_I2cDeviceProperty.h>

namespace nnd { namespace i2c { namespace skeleton { namespace detail {

// TODO: Add mutex if needed
class I2cDevicePropertyAllocator
{
public:
    I2cDevicePropertyAllocator(nn::i2c::driver::I2cDeviceProperty* pBuffer, int bufferCount) NN_NOEXCEPT
    {
        m_FreeList.clear();
        for ( int i = 0; i < bufferCount; ++i )
        {
            m_FreeList.push_back(pBuffer[i]);
        }
    }

    nn::i2c::driver::I2cDeviceProperty* Alloc() NN_NOEXCEPT
    {
        if ( m_FreeList.empty() )
        {
            return nullptr;
        }
        auto p = &m_FreeList.front();
        m_FreeList.pop_front();
        return p->SafeCastToPointer<nn::i2c::driver::I2cDeviceProperty>();
    }

    void Free(nn::i2c::driver::I2cDeviceProperty* p) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(p);
        NN_SDK_ASSERT(!p->IsLinkedToList());
        m_FreeList.push_front(*p);
    }

private:
    nn::i2c::driver::I2cDeviceProperty::List m_FreeList;
};

template<int MaxI2cDevicePropertyCount>
class I2cDevicePropertyManager
{
public:
    I2cDevicePropertyManager() NN_NOEXCEPT
    {}

    I2cDevicePropertyAllocator& GetAllocator() NN_NOEXCEPT
    {
        return m_Allocator;
    }

private:
    nn::i2c::driver::I2cDeviceProperty m_EntryBuffer[MaxI2cDevicePropertyCount];
    I2cDevicePropertyAllocator m_Allocator { m_EntryBuffer, MaxI2cDevicePropertyCount };
};

}}}} // nnd::i2c::skeleton::detail
