﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/devicecode/devicecode_Builder.h>

#include <nn/gpio/driver/gpio_DriverService.h>

#include "gpioSkeleton_DriverImpl.h"

NN_DDSF_CAST_SAFE_DEFINE(nnd::gpio::skeleton::detail::DriverImpl, nn::gpio::driver::IGpioDriver);

// TEST category can be used to generate device codes for internal/local usage
#define NND_SKELETON_DEVICECODE_TEST1 NN_DEVICECODE_MAKE_CODE(TEST, 0x0001)
#define NND_SKELETON_DEVICECODE_TEST2 NN_DEVICECODE_MAKE_CODE(TEST, 0x0002)

namespace
{
    struct PadInfo
    {
        nn::DeviceCode deviceCode;
        nn::gpio::driver::Pad pad;

        PadInfo(nn::DeviceCode deviceCode, int padNumber) NN_NOEXCEPT :
            deviceCode(deviceCode),
            pad(padNumber)
        {}
    } PadList[] =
    {
        { NND_SKELETON_DEVICECODE_TEST1, 0x1 },
        { NND_SKELETON_DEVICECODE_TEST2, 0x2 },
    };
}

namespace nnd { namespace gpio { namespace skeleton { namespace detail {

void DriverImpl::InitializeDriver() NN_NOEXCEPT
{
    for ( auto&& p : PadList )
    {
        nn::gpio::driver::RegisterDeviceCode(p.deviceCode, &p.pad);
    }
}

nn::Result DriverImpl::GetDirection(nn::gpio::Direction* pOut, nn::gpio::driver::Pad* pPad) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOut);
    NN_SDK_REQUIRES_NOT_NULL(pPad);

    // Implement me
    NN_UNUSED(pOut);
    NN_UNUSED(pPad);

    NN_RESULT_SUCCESS;
}

nn::Result DriverImpl::SetDirection(nn::gpio::driver::Pad* pPad, nn::gpio::Direction direction) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pPad);

    // Implement me
    NN_UNUSED(pPad);
    NN_UNUSED(direction);

    NN_RESULT_SUCCESS;
}

nn::Result DriverImpl::GetValue(nn::gpio::GpioValue* pOut, nn::gpio::driver::Pad* pPad) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOut);
    NN_SDK_REQUIRES_NOT_NULL(pPad);

    // Implement me
    NN_UNUSED(pOut);
    NN_UNUSED(pPad);

    NN_RESULT_SUCCESS;
}

nn::Result DriverImpl::SetValue(nn::gpio::driver::Pad* pPad, nn::gpio::GpioValue value) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pPad);

    // Implement me
    NN_UNUSED(pPad);
    NN_UNUSED(value);

    NN_RESULT_SUCCESS;
}

}}}} // nnd::gpio::skeleton::detail
