﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       ftm ドライバの検査工程開発者向け API のメイン実装です。
 */

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>

#include <nnd/ftm/ftm_Fab.h>

#include "ftm_Common.h"
#include "detail/ftm_Driver.h"

namespace nnd { namespace ftm {

// 実体は ftm_Api.cpp 内で宣言
extern DeviceState g_DeviceState;

::nn::Result RunItoTest(ItoEventReport* pOutItoEventReport) NN_NOEXCEPT
{
    // Sensing 状態を要求
    NN_SDK_REQUIRES(
        g_DeviceState == DeviceState::Sensing, "Please call nnd::ftm::ActivateSensing()\n");

    detail::IController* pController = detail::GetController();
    return pController->RunItoTest(pOutItoEventReport);
}

::nn::Result ReadMutualCompensationData(MutualCompensationData* pOutCompensationData) NN_NOEXCEPT
{
    // Ready 状態を要求
    NN_SDK_REQUIRES(
        g_DeviceState == DeviceState::Ready, "Please call nnd::ftm::ResetDevice()\n");

    detail::IController* pController = detail::GetController();
    return pController->ReadMutualCompensationData(pOutCompensationData);
}

::nn::Result ReadSelfCompensationData(SelfCompensationData* pOutCompensationData) NN_NOEXCEPT
{
    // Ready 状態を要求
    NN_SDK_REQUIRES(
        g_DeviceState == DeviceState::Ready, "Please call nnd::ftm::ResetDevice()\n");

    detail::IController* pController = detail::GetController();
    return pController->ReadSelfCompensationData(pOutCompensationData);
}

::nn::Result ReadMutualRawData(MutualRawData* pOutRawData) NN_NOEXCEPT
{
    // Ready 状態を要求
    NN_SDK_REQUIRES(
        g_DeviceState == DeviceState::Ready, "Please call nnd::ftm::ResetDevice()\n");

    detail::IController* pController = detail::GetController();
    return pController->ReadMutualRawData(pOutRawData);
}

::nn::Result ReadSelfRawData(SelfRawData* pOutRawData) NN_NOEXCEPT
{
    // Ready 状態を要求
    NN_SDK_REQUIRES(
        g_DeviceState == DeviceState::Ready, "Please call nnd::ftm::ResetDevice()\n");

    detail::IController* pController = detail::GetController();
    return pController->ReadSelfRawData(pOutRawData);
}

}} // namespace nnd::ftm

