﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   ftm のドライバで使用するバスに関する定義です。
 */

#pragma once

#include <nn/i2c/i2c.h>

namespace nnd { namespace ftm { namespace detail {

const ::nn::i2c::TransactionOption    I2cTransStop        = ::nn::i2c::TransactionOption_StopCondition;
const ::nn::i2c::TransactionOption    I2cTransStart       = ::nn::i2c::TransactionOption_StartCondition;
const ::nn::i2c::TransactionOption    I2cTransStartStop   = static_cast<::nn::i2c::TransactionOption>(
                                                                ::nn::i2c::TransactionOption_StartCondition
                                                                | ::nn::i2c::TransactionOption_StopCondition);

}}} // namespace nnd::ftm::detail
