﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       タッチコントローラ ftm3bd56 のデバイス固有の定義です。
 */

#pragma once

#include "ftm_Driver.h"

namespace nnd { namespace ftm { namespace detail {

class Ftm3bd56Controller : public IController
{
public:
    Ftm3bd56Controller() NN_NOEXCEPT;
    virtual ::nn::Result ResetDevice() const NN_NOEXCEPT NN_OVERRIDE;
    virtual ::nn::Result SleepInDevice() const NN_NOEXCEPT NN_OVERRIDE;
    virtual ::nn::Result SleepOutDevice() const NN_NOEXCEPT NN_OVERRIDE;
    virtual ::nn::Result BindInterrupt() const NN_NOEXCEPT NN_OVERRIDE;
    virtual ::nn::Result ActivateSensing() const NN_NOEXCEPT NN_OVERRIDE;
    virtual ::nn::Result DeactivateSensing() const NN_NOEXCEPT NN_OVERRIDE;
    virtual ::nn::Result ReadLeftEventCount(uint32_t* pOutLeftCount) const NN_NOEXCEPT NN_OVERRIDE;
    virtual ::nn::Result ReadEventReports(char* pOutReadData, uint32_t* pOutReadCount, bool* pOutIsOverflow, uint32_t readCount) const NN_NOEXCEPT NN_OVERRIDE;
    virtual ::nn::Result ReadEventReports(char* pOutReadData, uint32_t* pOutReadCount, uint32_t* pOutLeftCount, bool* pOutIsOverflow, uint32_t readCount) const NN_NOEXCEPT NN_OVERRIDE;
    virtual void ParseEventReports(EventReport* pOutEventReport, const char* pRawData, uint32_t parseCount) const NN_NOEXCEPT NN_OVERRIDE;

private:
    ::nn::Result ReadInformation(char* pOutInformation, size_t size) const NN_NOEXCEPT;
    ::nn::Result WaitForControllerReady() const NN_NOEXCEPT;
    EventId ConvertEventValToEnum(uint8_t idVal) const NN_NOEXCEPT;
    TouchEventReport ParseTouchContent(const char* pRawData) const NN_NOEXCEPT;
    StatusType ParseStatusContent(const char* pRawData) const NN_NOEXCEPT;
    GpioInformEventReport ParseGpioStateContent(const char* pRawData) const NN_NOEXCEPT;
    int32_t ConvertOrientationValToEnum(uint8_t orientationVal) const NN_NOEXCEPT;
    StatusType ConvertStatusValToEnum(uint8_t statusVal) const NN_NOEXCEPT;
    ::nn::Result WriteRegister(const void* pInData, size_t dataBytes) const NN_NOEXCEPT;
    ::nn::Result ReadRegister(void* pBuffer, size_t receiveDataBytes, const nn::Bit8* pInData, size_t sendDataBytes) const NN_NOEXCEPT;
};

}}} // namespace nnd::ftm::detail
