﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

/**
 * 初期化と終了処理に関する関数群
 */

#include <nn/nn_Common.h>

#include <nn/TargetConfigs/build_Base.h>
#include <nn/i2c/i2c.h>

namespace nnd {
namespace bh1730fvc {
namespace detail {

bool Initialize(nn::i2c::I2cSession* pOutI2cSession) NN_NOEXCEPT;
void Finalize(nn::i2c::I2cSession* pI2cSession) NN_NOEXCEPT;
nn::Result GetMeasurementMode(nn::i2c::I2cSession session, MeasurementMode* pOutMode) NN_NOEXCEPT;
nn::Result SetMeasurementMode(nn::i2c::I2cSession session, MeasurementMode mode) NN_NOEXCEPT;
nn::Result GetMeasurementValue(nn::i2c::I2cSession session, MeasurementValue* pOutValue) NN_NOEXCEPT;
float CalculateLux(int visible, int infrared, Gain gain, nn::Bit8 cycle, bool* pOutOverflown) NN_NOEXCEPT;
nn::Result IsLuxUpdated(nn::i2c::I2cSession session, bool* pOutUpdated) NN_NOEXCEPT;
nn::Result ReadRevisionId(nn::i2c::I2cSession session, nn::Bit8* pOutId) NN_NOEXCEPT;
nn::Result GetIntegralCycle(nn::i2c::I2cSession session, int* pOutCycle) NN_NOEXCEPT;
nn::Result SetIntegralCycle(nn::i2c::I2cSession session, int cycle) NN_NOEXCEPT;
nn::Result GetGain(nn::i2c::I2cSession session, Gain* pOutGain) NN_NOEXCEPT;
nn::Result SetGain(nn::i2c::I2cSession session, Gain gain) NN_NOEXCEPT;

// 内部関数
float CalculateLuxImpl(int visible, int infrared, Gain gain, nn::Bit8 cycle, bool* pOutOverflown) NN_NOEXCEPT;

} // detail
} // bh1730fvc
} // nnd
