﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

/**
 * @file
 * @brief   bh1730fvc ライブラリのデータ型や定数の定義です。
 */

#include <nn/nn_Common.h>
#include <nn/util/util_BitPack.h>

namespace nnd {
namespace bh1730fvc {

/**
 * @brief   ADC 分解能の設定
 */
enum class Gain: uint8_t
{
    X1     = 0,    //!< x1 gain
    X2     = 1,    //!< x2 gain
    X64    = 2,    //!< x64 gain
    X128   = 3,    //!< x128 gain
};


/**
 * @brief   計測モード
 */
enum class MeasurementMode: uint8_t
{
    Continuous, //!< Continuous モード
    OneShot,    //!< OneShot モード
    Manual,     //!< Manual モード
    Standby,    //!< Standby モード
};


/**
 * @brief   計測結果
 */
struct MeasurementValue
{
    float   lux;        //!< 照度値 [lux]
    int     visible;    //!< 可視光センサーデータの生値
    int     infrared;   //!< 赤外光センサーデータの生値
    bool    isOverflown; //!< 光量過多によりセンサー値が飽和するなどして照度値が信頼できない状態になっているか
};


} // bh1730fvc
} // nnd
