﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

/**
 * @file
 * @brief       明るさセンサー bh1730fvc のシステム開発者向け公開ヘッダです。
 */

/**
 * @namespace   nnd::bh1730fvc
 *
 * @brief       明るさセンサー bh1730fvc のドライバライブラリの名前空間です。
 *
 *              bh1730fvc ライブラリでは、明るさセンサー bh1730fvc を使用した照度値の計測機能を提供します。
 *
 *              #### 計測の仕組み
 *              ある計測期間の入力光を積分し、それをAD変換して数値化したものをセンサーの生値として出力します。
 *              本ライブラリでは、bh1730fvc で計測可能な可視光領域(MeasurmentValue.visible)と
 *              赤外光領域(MeasurmentValue.infrared)の２つのセンサー値から、照度値(MeasurmentValue.lux)を算出します。
 *
 *              #### 計測期間
 *              入力光を積分する期間を計測時間とします。
 *              本ライブラリでは計測の単位はサイクル数で扱います。1 サイクルは 2.7 ms です。
 *              計測時間の取得は @ref nnd::bh1730fvc::GetIntegralCycle() で行います。
 *              計測時間の変更は @ref nnd::bh1730fvc::SetIntegralCycle() で行います。
 *
 *              #### センサーのゲイン
 *              センサーの入力と出力の比率をゲインとします。
 *              ゲインの取得は @ref nnd::bh1730fvc::GetGain() で行います。
 *              ゲインの変更は @ref nnd::bh1730fvc::SetGain() で行います。
 *
 *              #### 感度の補正
 *              計測期間を長くし、ゲインを上げることで、光の少ない環境での計測や、センサー上部の光学窓による
 *              入光量の減衰の影響を補正することが可能です。
 *
 *              #### ライブラリの状態
 *              本ライブラリの持つ状態は以下のようになります。
 *              未初期化以外の状態を初期化済み状態と呼びます。
 *              @li 未初期化：ライブラリを初期化する前で何れの処理も実行できない状態です。
 *              @li Standby モード：ライブラリが初期化済みで、デバイスの操作が可能な状態です。
 *                  センシングは行われておらず、操作待ちの状態です。
 *              @li Continuous モード：計測を実行している状態です。
 *                  設定した計測頻度で定期的に計測結果の更新が行われる状態です。
 *              @li OneShot モード：計測を実行している状態です。
 *                  設定した計測頻度で計測が 1 回完了した後、自動的に Standby に遷移します。
 *              @li Manual モード：計測を実行している状態です。
 *                  計測頻度の設定を無視するため、計測結果を更新するためには
 *                  計測完了のための処理を要求する必要があります。
 *
 *
 */

#include "bh1730fvc_Api.h"
#include "bh1730fvc_Result.h"
#include "bh1730fvc_Types.h"
