﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   UART ドライバライブラリの初期化・終了機能の API 宣言（C リンケージ向けインタフェース）。
 */

#pragma once

#include <nnc/nn_Common.h>

//--------------------------------------------------------------------------
//  C/C++ 共通の宣言・定義
//--------------------------------------------------------------------------

#ifdef __cplusplus
extern "C"
{
#endif // ifdef __cplusplus

//! @name ライブラリの初期化・終了
//! @{

/**
 * @brief   UART ドライバライブラリを初期化します。
 *
 * @details
 *  この関数は、@ref nn::uart::Initialize() の C リンケージ向けインタフェースです。
 *  詳細は C++ 向け版を参照してください。
 *
 * @see
 *  nn::uart::Initialize()
 */
void nnuartInitialize();

/**
 * @brief   UART ドライバライブラリが初期化されているかどうかを返します。
 *
 * @return  ライブラリが初期化済かどうかを返します。
 *
 * @details
 *  この関数は、@ref nn::uart::IsInitialized() の C リンケージ向けインタフェースです。
 *  詳細は C++ 向け版を参照してください。
 *
 * @see
 *  nn::uart::IsInitialized()
 */
bool nnuartIsInitialized();

/**
 * @brief UART ドライバライブラリを終了します。
 *
 * @details
 *  この関数は、@ref nn::uart::Finalize() の C リンケージ向けインタフェースです。
 *  詳細は C++ 向け版を参照してください。
 *
 * @see
 *  nn::uart::Finalize()
 */
void nnuartFinalize();

//! @}

#ifdef __cplusplus
}
#endif // ifdef __cplusplus
