﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   GPIO ドライバライブラリで使用する PadMap を切り替えます。
 */

//--------------------------------------------------------------------------
//  C/C++ 共通の宣言・定義
//--------------------------------------------------------------------------

#pragma once

#include <nn/TargetConfigs/build_Base.h>

#if (defined(NN_GPIO_GEN) && ((NN_GPIO_GEN) == 2))
    // Gen2 API を使用するクライアントからのインクルードを禁止する
    // サーバ・ライブラリ内部からは (Gen1 互換のため) 参照する
    #error This header is not usable in gen 2.
#endif

// 対応プラットフォームが増えた場合は切り替えをここで行う
#if (defined(NN_BUILD_CONFIG_SPEC_GENERIC))
    #include <nnc/gpio/gpio_PadMap-spec.generic.h>
#elif (defined(NN_BUILD_CONFIG_SPEC_NX))
    #include <nnc/gpio/gpio_PadMap-spec.nx.h>
#else
    #error NN_BUILD_CONFIG_SPEC_ is not defined
#endif
