﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnc/nn_Common.h>

//--------------------------------------------------------------------------
//  C/C++ 共通の宣言・定義
//--------------------------------------------------------------------------

#ifdef __cplusplus
extern "C"
{
#endif // ifdef __cplusplus

/**
* @brief GPIO パッドの定義
*
* @details NX spec の GPIO ライブラリで現在対応している GPIO パッドの一覧です。
*/
typedef enum nngpioGpioPadName
{
    nngpioGpioPadName_CodecLdoEnTemp     = 1,  //!< CODEC_LDO_EN_TEMP
    nngpioGpioPadName_PowSdEn            = 2,  //!< POW_SD_EN
    nngpioGpioPadName_BtRst              = 3,  //!< BT_RST
    nngpioGpioPadName_DdrSel1            = 4,  //!< DDR_SEL1
    nngpioGpioPadName_GameCardReset      = 5,  //!< GAMECARD_REST
    nngpioGpioPadName_CodecAlert         = 6,  //!< CODEC_ALERT
    nngpioGpioPadName_PowGc              = 7,  //!< POW_GC
    nngpioGpioPadName_DebugControllerDet = 8,  //!< DEBUG_CONTROLLER_DET
    nngpioGpioPadName_BattChgStatus      = 9,  //!< BATT_CHG_STATUS
    nngpioGpioPadName_BattChgEnableN     = 10, //!< BATT_CHG_enable_n
    nngpioGpioPadName_FanTach            = 11, //!< FAN_TACH
    nngpioGpioPadName_ExtDetect          = 12, //!< EXT_DETECT
    nngpioGpioPadName_Vdd50AEn           = 13, //!< VDD50A-EN
    nngpioGpioPadName_SdevCoaxSel1       = 14, //!< SDEV_COAX_SEL_1
    nngpioGpioPadName_GameCardCd         = 15, //!< GAMECARD_CD
    nngpioGpioPadName_ProdType0          = 16, //!< PROD_TYPE_0
    nngpioGpioPadName_ProdType1          = 17, //!< PROD_TYPE_1
    nngpioGpioPadName_ProdType2          = 18, //!< PROD_TYPE_2
    nngpioGpioPadName_ProdType3          = 19, //!< PROD_TYPE_3
    nngpioGpioPadName_TempAlert          = 20, //!< TEMP_ALERT
    nngpioGpioPadName_CodecHpDetIrq      = 21, //!< CODEC_HP_DET_IRQ
    nngpioGpioPadName_RstMax77620En2     = 22, //!< RST_MAX77620-EN2
    nngpioGpioPadName_TpIrq              = 23, //!< TP_IRQ
    nngpioGpioPadName_ButtonSleep2       = 24, //!< BUTTON_sleep-2
    nngpioGpioPadName_ButtonVolUp        = 25, //!< BUTTON_VOL_UP
    nngpioGpioPadName_ButtonVolDn        = 26, //!< BUTTON_VOL_DN
    nngpioGpioPadName_BattMgicIrq        = 27, //!< BATT_MGIC_IRQ
    nngpioGpioPadName_RecoveryKey        = 28, //!< recovery_key
    nngpioGpioPadName_PowLcdBlEn         = 29, //!< POW_LCD_BL_EN
    nngpioGpioPadName_LcdReset           = 30, //!< LCD_reset
    nngpioGpioPadName_DevForceRecovery2  = 31, //!< DEV_FORCE_RECOVERY2
    nngpioGpioPadName_PdRstN             = 32, //!< PD_RST_n
    nngpioGpioPadName_Bq24190Irq         = 33, //!< BQ24190_IRQ
    nngpioGpioPadName_SdevCoaxSel0       = 34, //!< SDEV_COAX_SEL_0
    nngpioGpioPadName_SdWp               = 35, //!< SD_WP
    nngpioGpioPadName_TpReset            = 36, //!< TP_RESET
    nngpioGpioPadName_BtGpio1            = 37, //!< BT_GPIO_1
    nngpioGpioPadName_BtGpio2            = 38, //!< BT_GPIO_2
    nngpioGpioPadName_BtGpio3            = 39, //!< BT_GPIO_3
    nngpioGpioPadName_CradleIrq          = 40, //!< cradle_IRQ
    nngpioGpioPadName_PowVcpuInt         = 41, //!< POW_VCPU_INT
    nngpioGpioPadName_Max77621GpuInt     = 42, //!< MAX77621-GPU-INT
    nngpioGpioPadName_ProdBoot0          = 43, //!< PROD_BOOT_0
    nngpioGpioPadName_ProdBoot1          = 44, //!< PROD_BOOT_1
    nngpioGpioPadName_WifiPowerEnable    = 45, //!< WIFI_POWER_ENABLE
    nngpioGpioPadName_WifiReset          = 46, //!< WIFI_RESET
    nngpioGpioPadName_ApWakeBt           = 47, //!< AP_WAKE_BT
    nngpioGpioPadName_BtWakeAp           = 48, //!< BT_WAKE_AP
    nngpioGpioPadName_BtGpio4            = 49, //!< BT_GPIO_4
    nngpioGpioPadName_PowLcdVddPEn       = 50, //!< POW LCD_VDD_P_EN
    nngpioGpioPadName_PowLcdVddNEn       = 51, //!< POW LCD_VDD_N_EN
    nngpioGpioPadName_Ext2Detect         = 52, //!< EXT2_DETECT
    nngpioGpioPadName_DdrSel2            = 53, //!< DDR_SEL2
    nngpioGpioPadName_Vdd50BEn           = 54, //!< VDD50B-EN
    nngpioGpioPadName_BattChgOtg         = 55, //!< BATT_CHG_OTG

    // For Compatibility with Generic Header
    // Please Do Not Use For NX Spec Development
    nngpioGpioPadName_AudioPowerEnable       = 1, //!< Audio CODEC Power Enable
    nngpioGpioPadName_EnablePowerToTheSdCard = 2, //!< Enable Power To the SD Card
    nngpioGpioPadName_BluetoothPowerEnable   = 3, //!< Bluetooth Power Enable

} nngpioGpioPadName;

#ifdef __cplusplus
}
#endif // ifdef __cplusplus
