﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn{ namespace vi{

    /**
     * @brief VI ライブラリの使用する Relay Proxy の名前にカスタム値を設定します。
     *
     * @pre
     *       - VI ライブラリが初期化されていない。
     * @post
     *       - Relay Proxy の名前としてカスタム値が設定されている。
     *
     * @details
     *   この API は SDK 開発者向けの機能であり、この API の使用は任意です。
     *   この API を呼び出さなかった場合、 Relay Proxy にはデフォルトの名前が使用されます。@n
     */
    void SetRelayProxyName(const char* name) NN_NOEXCEPT;

}}
