﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   Defines settings for use with layers.
 * @details The declarations in this file are for internal developers only
 *          and not to be released to third parties.
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace vi {

    /**
     * @brief Layer creation settings.
     */
    struct LayerFlags
    {
        typedef nn::util::BitFlagSet<32, LayerFlags>::Flag<0> Fullscreen; //!< The display server will automatically scale
                                                                         //!< the layer to the current display resolution.
        typedef nn::util::BitFlagSet<32, LayerFlags>::Flag<1> Opaque;
    };

    typedef nn::util::BitFlagSet<32, LayerFlags> LayerSettings;

    /**
     * @brief Initializes default settings for layers.
     *
     * @param[out] pOutSettings Settings to initialize.
     *
     * @pre
     *       - VI library is initialized.
     *       - @a pOutSettings != nullptr
     * @post Default settings written to @a pOutSettings.
     */
    void SetLayerSettingsDefaults(LayerSettings* pOutSettings) NN_NOEXCEPT;

}}
