﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Defines all potential modes available to the Color Management Unit (CMU).
 */

#pragma once

namespace nn { namespace vi {

    /**
     * @brief   Modes available on the CMU.
     * @details Not all modes may be supported on all displays.
     *          These modes are mutually exclusive.
     */
    enum CmuMode
    {
        CmuMode_Disabled,     //!< CMU will not apply any transformations.
        CmuMode_Default,      //!< Applies the default settings for the CMU.
        CmuMode_InvertColor,  //!< Performs color inversion.
        CmuMode_HighContrast, //!< Enables high contrast mode.
        CmuMode_Grayscale,    //!< Performs grayscale conversion.
    };

}}
