﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_StaticAssert.h>

namespace nn{ namespace vi{ namespace native{

    struct NativeMemoryHandleId
    {
        uint32_t _data;
    };

    struct NativeSync
    {
        NN_ALIGNAS(4) char _data[36];
    };

    struct NativeSyncImpl
    {
    public:
        static const int CountMax = 4;
    public:
        struct FenceImpl{
            uint32_t id;
            uint32_t value;
        };
    public:
        uint32_t count;
        FenceImpl list[CountMax];
    };

    NN_STATIC_ASSERT(sizeof(NativeSync) == sizeof(NativeSyncImpl));
    NN_STATIC_ASSERT(NN_ALIGNOF(NativeSync) >= NN_ALIGNOF(NativeSyncImpl));

}}}
