﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/usb/usb_HostTypes.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace usb { namespace hs { // NOLINT(whitespace/braces)

class IClientEpSession;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IClientEpSession, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IClientEpSession)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ReOpen)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Close)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCompletionEvent, (::nn::sf::Out<::nn::sf::NativeHandle> eventHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(PopulateRing)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PostBufferAsync, (::nn::sf::Out<::std::uint32_t> pXferId, ::std::uint64_t address, ::std::uint32_t bytes, ::std::uint64_t context))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetXferReport, (::nn::sf::Out<::std::uint32_t> pOutCount, const ::nn::sf::OutBuffer& buffer, ::std::uint32_t count))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BatchBufferAsync, (::nn::sf::Out<::std::uint32_t> pXferId, ::std::uint64_t address, const ::nn::sf::InBuffer& sizeArray, ::std::uint32_t xferCount, ::std::uint64_t context, ::nn::usb::SchedulePolicy policy, ::std::uint32_t frameId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateSmmuSpace, (::std::uint64_t address, ::std::uint32_t size))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ShareReportRing, (::nn::sf::NativeHandle&& ringHandle, ::std::uint32_t size))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IClientEpSession)

        ::nn::Result ReOpen() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ReOpen);
        }

        ::nn::Result Close() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Close);
        }

        ::nn::Result GetCompletionEvent(::nn::sf::Out<::nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCompletionEvent, (eventHandle));
        }

        ::nn::Result PopulateRing() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(PopulateRing);
        }

        ::nn::Result PostBufferAsync(::nn::sf::Out<::std::uint32_t> pXferId, ::std::uint64_t address, ::std::uint32_t bytes, ::std::uint64_t context) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PostBufferAsync, (pXferId, address, bytes, context));
        }

        ::nn::Result GetXferReport(::nn::sf::Out<::std::uint32_t> pOutCount, const ::nn::sf::OutBuffer& buffer, ::std::uint32_t count) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetXferReport, (pOutCount, buffer, count));
        }

        ::nn::Result BatchBufferAsync(::nn::sf::Out<::std::uint32_t> pXferId, ::std::uint64_t address, const ::nn::sf::InBuffer& sizeArray, ::std::uint32_t xferCount, ::std::uint64_t context, ::nn::usb::SchedulePolicy policy, ::std::uint32_t frameId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BatchBufferAsync, (pXferId, address, sizeArray, xferCount, context, policy, frameId));
        }

        ::nn::Result CreateSmmuSpace(::std::uint64_t address, ::std::uint32_t size) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateSmmuSpace, (address, size));
        }

        ::nn::Result ShareReportRing(::nn::sf::NativeHandle&& ringHandle, ::std::uint32_t size) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ShareReportRing, (::std::move(ringHandle), size));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IClientEpSession
    {
    public:
        nn::Result ReOpen() NN_NOEXCEPT;
        nn::Result Close() NN_NOEXCEPT;
        nn::Result GetCompletionEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT;
        nn::Result PopulateRing() NN_NOEXCEPT;
        nn::Result PostBufferAsync(nn::sf::Out<std::uint32_t> pXferId, std::uint64_t address, std::uint32_t bytes, std::uint64_t context) NN_NOEXCEPT;
        nn::Result GetXferReport(nn::sf::Out<std::uint32_t> pOutCount, const nn::sf::OutBuffer& buffer, std::uint32_t count) NN_NOEXCEPT;
        nn::Result BatchBufferAsync(nn::sf::Out<std::uint32_t> pXferId, std::uint64_t address, const nn::sf::InBuffer& sizeArray, std::uint32_t xferCount, std::uint64_t context, nn::usb::SchedulePolicy policy, std::uint32_t frameId) NN_NOEXCEPT;
        nn::Result CreateSmmuSpace(std::uint64_t address, std::uint32_t size) NN_NOEXCEPT;
        nn::Result ShareReportRing(nn::sf::NativeHandle&& ringHandle, std::uint32_t size) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result ReOpen() NN_NOEXCEPT;
    nn::Result Close() NN_NOEXCEPT;
    nn::Result GetCompletionEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT;
    nn::Result PopulateRing() NN_NOEXCEPT;
    nn::Result PostBufferAsync(nn::sf::Out<std::uint32_t> pXferId, std::uint64_t address, std::uint32_t bytes, std::uint64_t context) NN_NOEXCEPT;
    nn::Result GetXferReport(nn::sf::Out<std::uint32_t> pOutCount, const nn::sf::OutBuffer& buffer, std::uint32_t count) NN_NOEXCEPT;
    nn::Result BatchBufferAsync(nn::sf::Out<std::uint32_t> pXferId, std::uint64_t address, const nn::sf::InBuffer& sizeArray, std::uint32_t xferCount, std::uint64_t context, nn::usb::SchedulePolicy policy, std::uint32_t frameId) NN_NOEXCEPT;
    nn::Result CreateSmmuSpace(std::uint64_t address, std::uint32_t size) NN_NOEXCEPT;
    nn::Result ShareReportRing(nn::sf::NativeHandle&& ringHandle, std::uint32_t size) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::usb::hs::IClientEpSession))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ReOpen)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ReOpen);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Close)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Close);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCompletionEvent, (::nn::sf::Out<::nn::sf::NativeHandle> eventHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCompletionEvent, (eventHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(PopulateRing)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(PopulateRing);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PostBufferAsync, (::nn::sf::Out<::std::uint32_t> pXferId, ::std::uint64_t address, ::std::uint32_t bytes, ::std::uint64_t context))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PostBufferAsync, (pXferId, address, bytes, context));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetXferReport, (::nn::sf::Out<::std::uint32_t> pOutCount, const ::nn::sf::OutBuffer& buffer, ::std::uint32_t count))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetXferReport, (pOutCount, buffer, count));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BatchBufferAsync, (::nn::sf::Out<::std::uint32_t> pXferId, ::std::uint64_t address, const ::nn::sf::InBuffer& sizeArray, ::std::uint32_t xferCount, ::std::uint64_t context, ::nn::usb::SchedulePolicy policy, ::std::uint32_t frameId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BatchBufferAsync, (pXferId, address, sizeArray, xferCount, context, policy, frameId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSmmuSpace, (::std::uint64_t address, ::std::uint32_t size))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateSmmuSpace, (address, size));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ShareReportRing, (::nn::sf::NativeHandle&& ringHandle, ::std::uint32_t size))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ShareReportRing, (::std::move(ringHandle), size));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::usb::hs::IClientEpSession>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::usb::hs::IClientEpSession))

    // nn::Result ReOpen() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReOpen)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReOpen)

    // nn::Result Close() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Close)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Close)

    // nn::Result GetCompletionEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCompletionEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(eventHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (eventHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eventHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCompletionEvent)

    // nn::Result PopulateRing() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PopulateRing)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PopulateRing)

    // nn::Result PostBufferAsync(nn::sf::Out<std::uint32_t> pXferId, std::uint64_t address, std::uint32_t bytes, std::uint64_t context) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PostBufferAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bytes, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(address, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(context, (::std::uint64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (bytes, address, context))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pXferId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pXferId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pXferId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(address), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bytes), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(context)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PostBufferAsync)

    // nn::Result GetXferReport(nn::sf::Out<std::uint32_t> pOutCount, const nn::sf::OutBuffer& buffer, std::uint32_t count) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetXferReport)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(count, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (count))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(count)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetXferReport)

    // nn::Result BatchBufferAsync(nn::sf::Out<std::uint32_t> pXferId, std::uint64_t address, const nn::sf::InBuffer& sizeArray, std::uint32_t xferCount, std::uint64_t context, nn::usb::SchedulePolicy policy, std::uint32_t frameId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BatchBufferAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(sizeArray, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (sizeArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(xferCount, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(policy, (::nn::usb::SchedulePolicy), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(frameId, (::std::uint32_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(address, (::std::uint64_t), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(context, (::std::uint64_t), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(5, (xferCount, policy, frameId, address, context))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pXferId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pXferId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pXferId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(address), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sizeArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(xferCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(context), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(policy), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(frameId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BatchBufferAsync)

    // nn::Result CreateSmmuSpace(std::uint64_t address, std::uint32_t size) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateSmmuSpace)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(address, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (size, address))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(address), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateSmmuSpace)

    // nn::Result ShareReportRing(nn::sf::NativeHandle&& ringHandle, std::uint32_t size) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ShareReportRing)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(ringHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (ringHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (size))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ringHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ShareReportRing)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::usb::SchedulePolicy), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::usb::hs::IClientEpSession, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::usb::hs::IClientEpSession))

    // nn::Result ReOpen() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ReOpen)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReOpen)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReOpen)
    }

    // nn::Result Close() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Close)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Close)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Close)
    }

    // nn::Result GetCompletionEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCompletionEvent, (::nn::sf::Out<::nn::sf::NativeHandle> eventHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCompletionEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eventHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCompletionEvent)
    }

    // nn::Result PopulateRing() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(PopulateRing)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PopulateRing)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PopulateRing)
    }

    // nn::Result PostBufferAsync(nn::sf::Out<std::uint32_t> pXferId, std::uint64_t address, std::uint32_t bytes, std::uint64_t context) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PostBufferAsync, (::nn::sf::Out<::std::uint32_t> pXferId, ::std::uint64_t address, ::std::uint32_t bytes, ::std::uint64_t context))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PostBufferAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pXferId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(address)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bytes)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(context)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PostBufferAsync)
    }

    // nn::Result GetXferReport(nn::sf::Out<std::uint32_t> pOutCount, const nn::sf::OutBuffer& buffer, std::uint32_t count) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetXferReport, (::nn::sf::Out<::std::uint32_t> pOutCount, const ::nn::sf::OutBuffer& buffer, ::std::uint32_t count))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetXferReport)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(count)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetXferReport)
    }

    // nn::Result BatchBufferAsync(nn::sf::Out<std::uint32_t> pXferId, std::uint64_t address, const nn::sf::InBuffer& sizeArray, std::uint32_t xferCount, std::uint64_t context, nn::usb::SchedulePolicy policy, std::uint32_t frameId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BatchBufferAsync, (::nn::sf::Out<::std::uint32_t> pXferId, ::std::uint64_t address, const ::nn::sf::InBuffer& sizeArray, ::std::uint32_t xferCount, ::std::uint64_t context, ::nn::usb::SchedulePolicy policy, ::std::uint32_t frameId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BatchBufferAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pXferId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(address)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sizeArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(xferCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(context)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(policy)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(frameId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BatchBufferAsync)
    }

    // nn::Result CreateSmmuSpace(std::uint64_t address, std::uint32_t size) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSmmuSpace, (::std::uint64_t address, ::std::uint32_t size))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateSmmuSpace)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(address)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateSmmuSpace)
    }

    // nn::Result ShareReportRing(nn::sf::NativeHandle&& ringHandle, std::uint32_t size) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ShareReportRing, (::nn::sf::NativeHandle&& ringHandle, ::std::uint32_t size))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ShareReportRing)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ringHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ShareReportRing)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::usb::hs::IClientEpSession>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::usb::hs::IClientEpSession))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReOpen)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReOpen)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Close)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Close)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCompletionEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(eventHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCompletionEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(eventHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PopulateRing)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PopulateRing)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PostBufferAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PostBufferAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pXferId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(address),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bytes),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(context)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetXferReport)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetXferReport)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(count)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BatchBufferAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(sizeArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BatchBufferAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pXferId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(address),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(sizeArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(xferCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(context),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(policy),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(frameId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateSmmuSpace)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateSmmuSpace)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(address),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ShareReportRing)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(ringHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ShareReportRing)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(ringHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReOpen)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Close)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCompletionEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PopulateRing)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PostBufferAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetXferReport)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BatchBufferAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateSmmuSpace)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ShareReportRing)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::usb::hs::IClientEpSession))
