﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      usb モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_USB_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(usb, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_USB_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(usb, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_USB_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(usb, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_USB_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(usb, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_USB_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(usb, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_USB_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(usb, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_USB_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(usb, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_USB_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(usb, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_USB_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(usb, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_USB_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(usb, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_USB_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(usb, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_USB_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(usb, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_USB_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(usb, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_USB_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(usb, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_USB_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(usb, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_USB_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(usb, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_USB_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(usb, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_USB_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(usb, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_USB_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(usb, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_USB_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(usb, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_USB_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(usb, Trace, 0, format, args)
#define NN_DETAIL_USB_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(usb, Trace, 1, format, args)
#define NN_DETAIL_USB_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(usb, Trace, 2, format, args)
#define NN_DETAIL_USB_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(usb, Trace, 3, format, args)

#define NN_DETAIL_USB_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(usb, Info, 0, format, args)
#define NN_DETAIL_USB_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(usb, Info, 1, format, args)
#define NN_DETAIL_USB_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(usb, Info, 2, format, args)
#define NN_DETAIL_USB_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(usb, Info, 3, format, args)

#define NN_DETAIL_USB_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(usb, Warn, 0, format, args)
#define NN_DETAIL_USB_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(usb, Warn, 1, format, args)
#define NN_DETAIL_USB_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(usb, Warn, 2, format, args)
#define NN_DETAIL_USB_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(usb, Warn, 3, format, args)

#define NN_DETAIL_USB_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(usb, Error, 0, format, args)
#define NN_DETAIL_USB_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(usb, Error, 1, format, args)
#define NN_DETAIL_USB_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(usb, Error, 2, format, args)
#define NN_DETAIL_USB_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(usb, Error, 3, format, args)

#define NN_DETAIL_USB_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(usb, Fatal, 0, format, args)
#define NN_DETAIL_USB_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(usb, Fatal, 1, format, args)
#define NN_DETAIL_USB_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(usb, Fatal, 2, format, args)
#define NN_DETAIL_USB_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(usb, Fatal, 3, format, args)

#define NN_DETAIL_USB_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(usb, Trace, 0, text, length)
#define NN_DETAIL_USB_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(usb, Trace, 1, text, length)
#define NN_DETAIL_USB_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(usb, Trace, 2, text, length)
#define NN_DETAIL_USB_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(usb, Trace, 3, text, length)

#define NN_DETAIL_USB_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(usb, Info, 0, text, length)
#define NN_DETAIL_USB_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(usb, Info, 1, text, length)
#define NN_DETAIL_USB_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(usb, Info, 2, text, length)
#define NN_DETAIL_USB_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(usb, Info, 3, text, length)

#define NN_DETAIL_USB_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(usb, Warn, 0, text, length)
#define NN_DETAIL_USB_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(usb, Warn, 1, text, length)
#define NN_DETAIL_USB_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(usb, Warn, 2, text, length)
#define NN_DETAIL_USB_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(usb, Warn, 3, text, length)

#define NN_DETAIL_USB_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(usb, Error, 0, text, length)
#define NN_DETAIL_USB_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(usb, Error, 1, text, length)
#define NN_DETAIL_USB_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(usb, Error, 2, text, length)
#define NN_DETAIL_USB_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(usb, Error, 3, text, length)

#define NN_DETAIL_USB_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(usb, Fatal, 0, text, length)
#define NN_DETAIL_USB_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(usb, Fatal, 1, text, length)
#define NN_DETAIL_USB_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(usb, Fatal, 2, text, length)
#define NN_DETAIL_USB_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(usb, Fatal, 3, text, length)
