﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

/**
 * @file
 * @brief   温度センサーライブラリのデータ型や定数の定義です。
 */

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/os/os_SystemEvent.h>

namespace nn {
namespace ts {

/**
 * @brief   温度値の上限と下限を持つ構造体です。
 */
struct LimitTemperature
{
    int     low;    //!< 下限
    int     high;   //!< 上限
};

/**
 * @brief   温度検知を行う設定値を持つ構造体です。
 */
struct ExceededStatus
{
    bool    lowLimitExceeded;   //!< 下限値を検知したかどうか
    bool    highLimitExceeded;  //!< 上限値を検知したかどうか
};

/**
 * @brief   温度センサーの動作モードを表す列挙型です。
 */
enum class MeasurementMode: uint8_t
{
    Standby,
    Continuous,
};

} // ts
} // nn
