﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/ts/ts_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace ts { namespace server { // NOLINT(whitespace/braces)

class IMeasurementServer;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IMeasurementServer, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IMeasurementServer)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetTemperatureRange, (::nn::sf::Out<::nn::ts::LimitTemperature> outLimitTemperature, ::std::uint8_t location))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetTemperature, (::nn::sf::Out<int> outTemperature, ::std::uint8_t location))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetMeasurementMode, (::std::uint8_t location, ::std::uint8_t measurementMode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetTemperatureMilliC, (::nn::sf::Out<int> outTemperatureMilliC, ::std::uint8_t location))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IMeasurementServer)

        ::nn::Result GetTemperatureRange(::nn::sf::Out<::nn::ts::LimitTemperature> outLimitTemperature, ::std::uint8_t location) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetTemperatureRange, (outLimitTemperature, location));
        }

        ::nn::Result GetTemperature(::nn::sf::Out<int> outTemperature, ::std::uint8_t location) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetTemperature, (outTemperature, location));
        }

        ::nn::Result SetMeasurementMode(::std::uint8_t location, ::std::uint8_t measurementMode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetMeasurementMode, (location, measurementMode));
        }

        ::nn::Result GetTemperatureMilliC(::nn::sf::Out<int> outTemperatureMilliC, ::std::uint8_t location) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetTemperatureMilliC, (outTemperatureMilliC, location));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IMeasurementServer
    {
    public:
        nn::Result GetTemperatureRange(nn::sf::Out<nn::ts::LimitTemperature> outLimitTemperature, std::uint8_t location) NN_NOEXCEPT;
        nn::Result GetTemperature(nn::sf::Out<int> outTemperature, std::uint8_t location) NN_NOEXCEPT;
        nn::Result SetMeasurementMode(std::uint8_t location, std::uint8_t measurementMode) NN_NOEXCEPT;
        nn::Result GetTemperatureMilliC(nn::sf::Out<int> outTemperatureMilliC, std::uint8_t location) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetTemperatureRange(nn::sf::Out<nn::ts::LimitTemperature> outLimitTemperature, std::uint8_t location) NN_NOEXCEPT;
    nn::Result GetTemperature(nn::sf::Out<int> outTemperature, std::uint8_t location) NN_NOEXCEPT;
    nn::Result SetMeasurementMode(std::uint8_t location, std::uint8_t measurementMode) NN_NOEXCEPT;
    nn::Result GetTemperatureMilliC(nn::sf::Out<int> outTemperatureMilliC, std::uint8_t location) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ts::server::IMeasurementServer))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTemperatureRange, (::nn::sf::Out<::nn::ts::LimitTemperature> outLimitTemperature, ::std::uint8_t location))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetTemperatureRange, (outLimitTemperature, location));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTemperature, (::nn::sf::Out<int> outTemperature, ::std::uint8_t location))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetTemperature, (outTemperature, location));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetMeasurementMode, (::std::uint8_t location, ::std::uint8_t measurementMode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetMeasurementMode, (location, measurementMode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTemperatureMilliC, (::nn::sf::Out<int> outTemperatureMilliC, ::std::uint8_t location))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetTemperatureMilliC, (outTemperatureMilliC, location));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ts::server::IMeasurementServer>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ts::server::IMeasurementServer))

    // nn::Result GetTemperatureRange(nn::sf::Out<nn::ts::LimitTemperature> outLimitTemperature, std::uint8_t location) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetTemperatureRange)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(location, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (location))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outLimitTemperature, (::nn::ts::LimitTemperature), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outLimitTemperature))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outLimitTemperature), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(location)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetTemperatureRange)

    // nn::Result GetTemperature(nn::sf::Out<int> outTemperature, std::uint8_t location) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetTemperature)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(location, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (location))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outTemperature, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outTemperature))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outTemperature), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(location)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetTemperature)

    // nn::Result SetMeasurementMode(std::uint8_t location, std::uint8_t measurementMode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetMeasurementMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(location, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(measurementMode, (::std::uint8_t), 1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (location, measurementMode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(location), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(measurementMode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetMeasurementMode)

    // nn::Result GetTemperatureMilliC(nn::sf::Out<int> outTemperatureMilliC, std::uint8_t location) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetTemperatureMilliC)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(location, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (location))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outTemperatureMilliC, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outTemperatureMilliC))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outTemperatureMilliC), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(location)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetTemperatureMilliC)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ts::LimitTemperature), 8, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ts::server::IMeasurementServer, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ts::server::IMeasurementServer))

    // nn::Result GetTemperatureRange(nn::sf::Out<nn::ts::LimitTemperature> outLimitTemperature, std::uint8_t location) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTemperatureRange, (::nn::sf::Out<::nn::ts::LimitTemperature> outLimitTemperature, ::std::uint8_t location))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetTemperatureRange)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outLimitTemperature)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(location)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetTemperatureRange)
    }

    // nn::Result GetTemperature(nn::sf::Out<int> outTemperature, std::uint8_t location) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTemperature, (::nn::sf::Out<int> outTemperature, ::std::uint8_t location))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetTemperature)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outTemperature)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(location)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetTemperature)
    }

    // nn::Result SetMeasurementMode(std::uint8_t location, std::uint8_t measurementMode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetMeasurementMode, (::std::uint8_t location, ::std::uint8_t measurementMode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetMeasurementMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(location)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(measurementMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetMeasurementMode)
    }

    // nn::Result GetTemperatureMilliC(nn::sf::Out<int> outTemperatureMilliC, std::uint8_t location) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTemperatureMilliC, (::nn::sf::Out<int> outTemperatureMilliC, ::std::uint8_t location))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetTemperatureMilliC)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outTemperatureMilliC)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(location)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetTemperatureMilliC)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ts::server::IMeasurementServer>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ts::server::IMeasurementServer))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetTemperatureRange)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetTemperatureRange)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outLimitTemperature),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(location)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetTemperature)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetTemperature)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outTemperature),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(location)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetMeasurementMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetMeasurementMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(location),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(measurementMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetTemperatureMilliC)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetTemperatureMilliC)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outTemperatureMilliC),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(location)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetTemperatureRange)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetTemperature)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetMeasurementMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetTemperatureMilliC)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ts::server::IMeasurementServer))
