﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  夏時間（Daylight Saving Time）の有効性を表す列挙型の宣言
*/

#pragma once

#include <nn/time/time_Common.h>

namespace nn { namespace timesrv { namespace detail { namespace tz {

/**
* @brief    夏時間（Daylight Saving Time）の有効性を表す列挙型です。
* @details
*/
enum DaylightSavingTimeType
{
    DaylightSavingTimeType_Unknown = -1,   //!< 夏時間の有効性が不明
    DaylightSavingTimeType_NoEffect = 0,   //!< 夏時間が無効
    DaylightSavingTimeType_InEffect = 1,   //!< 夏時間が有効
};

}}}}
