﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/time/detail/time_CommonDetail.h>
#include <nn/time/time_LocationName.h>
#include <nn/time/time_SystemClockContext.h>

namespace nn
{
namespace timesrv
{
namespace detail
{
namespace settings
{

    //
    // nn::settings で時計設定を read/write するラッパー
    //

    nn::time::SourceId ReadSteadyClockSourceId() NN_NOEXCEPT;
    void WriteSteadyClockSourceId(const nn::time::SourceId& sourceId) NN_NOEXCEPT;

    nn::TimeSpan ReadSteadyClockInternalOffset() NN_NOEXCEPT;
    void WriteSteadyClockInternalOffset(const nn::TimeSpan internalOffset) NN_NOEXCEPT;

    nn::time::SystemClockContext ReadLocalSystemClockContext() NN_NOEXCEPT;
    void WriteLocalSystemClockContext(const nn::time::SystemClockContext& systemClockContext) NN_NOEXCEPT;

    nn::time::SystemClockContext ReadNetworkSystemClockContext() NN_NOEXCEPT;
    void WriteNetworkSystemClockContext(const nn::time::SystemClockContext& systemClockContext) NN_NOEXCEPT;
    nn::TimeSpan ReadNetworkClockSufficientAccuracyThreshold() NN_NOEXCEPT;

    bool ReadUserSystemClockAutomaticCorrectionEnabled() NN_NOEXCEPT;
    void WriteUserSystemClockAutomaticCorrectionEnabled(bool value) NN_NOEXCEPT;

    nn::time::SteadyClockTimePoint ReadUserSystemClockAutomaticCorrectionUpdatedTime() NN_NOEXCEPT;
    void WriteUserSystemClockAutomaticCorrectionUpdatedTime(const nn::time::SteadyClockTimePoint& value) NN_NOEXCEPT;

    nn::time::LocationName ReadDeviceLocationName() NN_NOEXCEPT;
    void WriteDeviceLocationName(const nn::time::LocationName& value) NN_NOEXCEPT;

    nn::time::SteadyClockTimePoint ReadDeviceLocationUpdatedTime() NN_NOEXCEPT;
    void WriteDeviceLocationUpdatedTime(const nn::time::SteadyClockTimePoint& value) NN_NOEXCEPT;

    nn::TimeSpan ReadStandardSteadyClockTestOffset() NN_NOEXCEPT;
    nn::TimeSpan ReadStandardSteadyClockRtcUpdateInterval() NN_NOEXCEPT;

    void ReadBoardType(char* pOut, size_t outSize) NN_NOEXCEPT;

    nn::TimeSpan ReadNotifyTimeToFsInterval() NN_NOEXCEPT;

    int ReadStandardUserSystemClockInitialYear() NN_NOEXCEPT;
}
}
}
}
