﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/time/detail/time_CommonDetail.h>

#include <nn/time/time_Types.h>


namespace nn
{
namespace timesrv
{
namespace detail
{
namespace core
{

class SteadyClockCore
{
private:
    virtual Result GetCurrentTimePointImpl(nn::time::SteadyClockTimePoint* pSteadyClockTimePoint) const NN_NOEXCEPT = 0;

    virtual nn::TimeSpan GetCurrentTimePointValueImpl() const NN_NOEXCEPT;
    virtual nn::TimeSpan GetTestOffsetImpl() const NN_NOEXCEPT;
    virtual void SetTestOffsetImpl(const nn::TimeSpan& testOffset) NN_NOEXCEPT;

    virtual nn::TimeSpan GetInternalOffsetImpl() const NN_NOEXCEPT;
    virtual void SetInternalOffsetImpl(const nn::TimeSpan& internalOffset) NN_NOEXCEPT;

    virtual Result GetRtcSecondsImpl(int64_t* pOutValue) NN_NOEXCEPT;

    bool m_IsRtcResetDetected;

public:
    SteadyClockCore() NN_NOEXCEPT;
    virtual ~SteadyClockCore() NN_NOEXCEPT;

    /**
     * @brief   単調増加クロックの指し示す現在の値を取得します。
     *
     * @param[out]  pOutSteadyClockTimePoint    単調増加クロック値を代入するバッファへのポインタを指定します。
     *
     * @pre
     *  - pOutSteadyClockTimePoint != nullptr
     *
     * @return  操作の結果を返します。 TODO: Result の詳細を追記
     *
     * @details
     */
    Result GetCurrentTimePoint(nn::time::SteadyClockTimePoint* pOutSteadyClockTimePoint) const NN_NOEXCEPT;

    /**
     * @brief   単調増加クロックの指し示す時刻のみを取得します。
     */
    nn::TimeSpan GetCurrentTimePointValue() const NN_NOEXCEPT;

    /**
     * @brief   単調増加クロックが利用するテスト用オフセットの値を取得します。
     *
     * @return  テスト用オフセット値
     *
     * @details
     *  製品でも関数自体は成功を返しますが、渡されたバッファに代入されるオフセットの値は、製品では必ず 0 になることが保証されます。
     */
    nn::TimeSpan GetTestOffset() const NN_NOEXCEPT;

    /**
     * @brief   単調増加クロックが利用するテスト用オフセットの値を指定します。
     *
     * @param[in]   testOffset  テスト用オフセットの値を指定します。
     *
     * @details
     *  製品でも関数自体は成功を返しますが、設定した値を取得することはできません。
     */
    void SetTestOffset(const nn::TimeSpan& testOffset) NN_NOEXCEPT;

    void SetInternalOffset(const nn::TimeSpan& internalOffset) NN_NOEXCEPT;
    nn::TimeSpan GetInternalOffset() const NN_NOEXCEPT;

    /**
     * @brief   RTC 値を秒単位で取得
     * @param[out]  pOutValue   RTC 値
     */
    Result GetRtcSeconds(int64_t* pOutValue) NN_NOEXCEPT;

    /**
     * @brief   RTC リセットが発生したかどうかを取得
     * @details
     *  初期値は false です。 DetectRtcReset() が呼ばれると true を返すようになり、
     *  以降システムがリセットされるまで同じ値を返します。
     */
    bool IsRtcResetDetected() const NN_NOEXCEPT;

    /**
     * @brief   RTC リセットが発生したことをセット
     * @details
     *  IsRtcResetDetected() が true を返すようになります。
     */
    void DetectRtcReset() NN_NOEXCEPT;

    // 問題調査用途 API
    virtual uint32_t GetSetupResultValue() const NN_NOEXCEPT { return 0; } //!< セットアップ時の Result 値を返す

};

}
}
}
}
