﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  システム向け API の宣言
*/

#pragma once

#include <nn/time/time_LocationName.h>


namespace nn
{
namespace time
{

//! @name システム向け API
//! @{

/**
 * @brief   システム向けの TIME ライブラリの初期化を行います。
 *
 * @return  処理の結果が返ります。事前条件を満たしていない場合、以下に列挙されていない失敗が返ることがあります。
 * @retval  ResultSuccess                       成功しました。
 *
 * @details
 *  本関数を使って TIME ライブラリを初期化した場合にも、破棄には nn::time::Finalize を利用してください。
 *  他の権限向けの初期化を行う @ref Initialize, @ref InitializeForMenu 関数と重ねて呼ぶことはできません。
 *
 *  ライブラリがすでに初期化された状態でも重ねて呼ぶことができますが、その場合、ライブラリの利用を完全に終了するにはこの関数を呼んだのと同じ回数だけ
 *  @ref nn::time::Finalize 関数を呼ぶ必要があります。
 *
 *  この関数を成功させるには、特権が必要です。
 */
Result InitializeForSystem() NN_NOEXCEPT;

/**
 * @brief   RTC がリセットされたかを取得します。(デバッグ用)
 * @return  RTC がリセットされたかどうか
 * @retval  true    リセットされた
 * @retval  false   リセットされていない
 * @pre
 *  - TIME ライブラリが初期化されている
 *
 * @details
 */
bool IsRtcResetDetected() NN_NOEXCEPT;

//! @}
}
}

#include <nn/time.h>
#include <nn/time/time_StandardNetworkSystemClockPrivilegeApi.h>
#include <nn/time/time_SteadyClockPrivateApi.h>
