﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/time/detail/time_CommonDetail.h>
#include <nn/time/detail/time_SharedMemoryType.h>
#include <nn/timesrv/detail/service/timesrv_IStaticService.sfdl.h>

namespace nn { namespace time { namespace detail {

class SharedMemoryClient
{
    NN_DISALLOW_COPY( SharedMemoryClient );
    NN_DISALLOW_MOVE( SharedMemoryClient );

public:
    explicit SharedMemoryClient(nn::sf::SharedPointer<nn::timesrv::detail::service::IStaticService> pIStaticService) NN_NOEXCEPT;

    // StandardSteadyClock
    void GetStandardSteadyClockCurrentTimePoint(nn::time::SteadyClockTimePoint* pOut) NN_NOEXCEPT;

    // StandardUserSystemClock
    void GetStandardUserSystemClockCurrentTime(nn::time::PosixTime* pOut) NN_NOEXCEPT;
    void GetStandardUserSystemClockContext(nn::time::SystemClockContext* pOut) NN_NOEXCEPT;
    bool IsStandardUserSystemClockAutomaticCorrectionEnabled() NN_NOEXCEPT;

    // StandardNetworkSystemClock
    nn::Result GetStandardNetworkSystemClockCurrentTime(nn::time::PosixTime* pOut) NN_NOEXCEPT;
    void GetStandardNetworkSystemClockContext(nn::time::SystemClockContext* pOut) NN_NOEXCEPT;

    // SystemClock汎用
    nn::Result CalculateSystemClockCurrentTime(nn::time::PosixTime* pOut, const nn::time::SystemClockContext& context) NN_NOEXCEPT;

private:
    nn::os::SharedMemory m_SharedMemory;
    SharedMemoryClockSettings* m_pSharedMemoryClockSettings;
};

}}}
