﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#define NN_DETAIL_TIME_CONFIG_SERVER_MODEL_PROCESS  0
#define NN_DETAIL_TIME_CONFIG_SERVER_MODEL_THREAD   1

#if defined(NN_BUILD_CONFIG_OS_WIN)
#define NN_DETAIL_TIME_CONFIG_SERVER_MODEL NN_DETAIL_TIME_CONFIG_SERVER_MODEL_THREAD
#else
#define NN_DETAIL_TIME_CONFIG_SERVER_MODEL NN_DETAIL_TIME_CONFIG_SERVER_MODEL_PROCESS
#endif

#define NN_DETAIL_TIME_CONFIG_SERVICE_FRAMEWORK_MODEL_DFC   0
#define NN_DETAIL_TIME_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC  1

#if defined(NN_BUILD_CONFIG_OS_WIN)
#define NN_DETAIL_TIME_CONFIG_SERVICE_FRAMEWORK_MODEL_DEFAULT   NN_DETAIL_TIME_CONFIG_SERVICE_FRAMEWORK_MODEL_DFC
#elif defined(NN_BUILD_CONFIG_OS_HORIZON)
#define NN_DETAIL_TIME_CONFIG_SERVICE_FRAMEWORK_MODEL_DEFAULT   NN_DETAIL_TIME_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
#else
#define NN_DETAIL_TIME_CONFIG_SERVICE_FRAMEWORK_MODEL_DEFAULT   NN_DETAIL_TIME_CONFIG_SERVICE_FRAMEWORK_MODEL_DFC
#endif

#define NN_DETAIL_TIME_CONFIG_SERVICE_FRAMEWORK_MODEL   NN_DETAIL_TIME_CONFIG_SERVICE_FRAMEWORK_MODEL_DEFAULT

#define NN_DETAIL_TIME_CONFIG_EXTERNAL_STEADY_CLOCK_MODEL_STD_CHRONO 1
#define NN_DETAIL_TIME_CONFIG_EXTERNAL_STEADY_CLOCK_MODEL_OS_TICK 2
#define NN_DETAIL_TIME_CONFIG_EXTERNAL_STEADY_CLOCK_MODEL_NX_PMIC 3

#define NN_DETAIL_TIME_CONFIG_TIMEZONE_BINARY_MODEL_SOURCE_LINK 1
#define NN_DETAIL_TIME_CONFIG_TIMEZONE_BINARY_MODEL_SYSTEM_DATA_TITLE 2

#if defined(NN_BUILD_CONFIG_OS_WIN)
#include "time_ConfigDetail.win32.h"
#elif defined(NN_BUILD_CONFIG_OS_HORIZON)
#include "time_ConfigDetail.horizon.h"
#endif
