﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief TCAP サーバライブラリ初期化・終了 API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace tcap { namespace server {

//! @name TCAP ライブラリ初期化・終了 API
//! @{

/**
 * @brief       TCAP サーバライブラリを初期化します。
 *
 * @post        TCAP サーバライブラリは初期化済の状態になります。
 *
 * @details     TCAP サーバライブラリを初期化します。@n
 *              ライブラリ初期化回数は内部でカウントされます。
 */
void Initialize() NN_NOEXCEPT;

/**
 * @brief       TCAP サーバライブラリを終了します。
 *
 * @post        TCAP サーバライブラリは初期化前の状態になります。
 *
 * @details     TCAP サーバライブラリを終了します。@n
 *              ライブラリ初期化を行った回数分、本関数が呼ばれた場合にのみ、ライブラリが初期化前の状態になります。
 */
void Finalize() NN_NOEXCEPT;

//! @}

}}} // namepsace nn::tcap::server
