﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

#include "../tc_Types.h"

namespace nn { namespace tc { namespace impl {

nn::Result SetOperatingMode(OperatingMode operatingMode) NN_NOEXCEPT;

nn::Result GetEventPtr(nn::os::SystemEventType** pOutEventPtr, EventTarget target) NN_NOEXCEPT;

nn::Result IsActionAllowed(bool* pOutPossible, Action action) NN_NOEXCEPT;

nn::Result EnableVirtualTemperature(Location location) NN_NOEXCEPT;

nn::Result DisableVirtualTemperature(Location location) NN_NOEXCEPT;

nn::Result SetVirtualTemperature(Location location, TemperatureMilliC temperature) NN_NOEXCEPT;

void Update() NN_NOEXCEPT;

nn::Result EnableFanControl() NN_NOEXCEPT;

nn::Result DisableFanControl() NN_NOEXCEPT;

nn::Result IsFanControlEnabled(bool* pOutEnabled) NN_NOEXCEPT;

int GetSkinTemperatureMilliC() NN_NOEXCEPT;

}}} // namepsace nn::tc::impl
