﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
* @file
* @brief   カスタムAPIを追加したソフトウェアキーボード
*/

#pragma once

#include "swkbd_InlineKeyboardApi.h"

namespace nn { namespace swkbd {

/**
* @brief   ソフトウェアキーボードに対して入力が禁止できるキーの種類です。
*          指定したキーをソフトウェアキーボードが使わなくなります。
* @details nn::swkbd::InvalidButton と同様に nn::swkbd::AppearArg::invalidButtonFlag に設定します。
*/
enum InvalidButtonS : uint32_t
{
    InvalidButtonS_Y     = 1 << 29, //!< Y ボタンの入力を禁止させます。
    InvalidButtonS_Minus = 1 << 30, //!< - ボタンの入力を禁止させます。
};

/**
* @brief カスタムAPIを追加したクラスです。
*/
class InlineKeyboardCustomS : public InlineKeyboard
{
    NN_DISALLOW_COPY(InlineKeyboardCustomS);

public:
    InlineKeyboardCustomS() NN_NOEXCEPT = default;
    ~InlineKeyboardCustomS() NN_NOEXCEPT = default;

    /**
    * @brief ソフトウェアキーボードが方向ボタンを使用するかどうかを指定します。
    * @param[in] 方向ボタンをソフトウェアキーボード側が使用する場合 true、使用しない場合は false。
    */
    void SetDirectionalButtonAssignEnabled( bool enable ) NN_NOEXCEPT;
};

} } // namespace nn::swkbd

