﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/ssl/detail/ssl_ISslContext.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace ssl { namespace sf { // NOLINT(whitespace/braces)

struct FlushSessionCacheOptionType;

class ISslService;

struct FlushSessionCacheOptionType
{
    std::uint32_t option;
};

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ISslService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ISslService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateContext, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ssl::sf::ISslContext>> outValue, ::nn::ssl::sf::SslVersion version, ::nn::Bit64 pid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetContextCount, (::nn::sf::Out<::std::uint32_t> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCertificates, (const ::nn::sf::OutBuffer& outCertsData, ::nn::sf::Out<::std::uint32_t> outIdCount, const ::nn::sf::InBuffer& inCertIds))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCertificateBufSize, (::nn::sf::Out<::std::uint32_t> outSize, const ::nn::sf::InBuffer& inCertIds))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DebugIoctl, (const ::nn::sf::OutBuffer& outBufferInfo, const ::nn::sf::InBuffer& inBufferInfo, ::std::uint64_t cmd))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetInterfaceVersion, (::std::uint32_t inValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FlushSessionCache, (::nn::sf::Out<::std::uint32_t> outEntriesDeletedCount, const ::nn::sf::InBuffer& pInHostNameBuf, ::nn::ssl::sf::FlushSessionCacheOptionType optionValue))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ISslService)

        ::nn::Result CreateContext(::nn::sf::Out<::nn::sf::SharedPointer<::nn::ssl::sf::ISslContext>> outValue, ::nn::ssl::sf::SslVersion version, ::nn::Bit64 pid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateContext, (outValue, version, pid));
        }

        ::nn::Result GetContextCount(::nn::sf::Out<::std::uint32_t> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetContextCount, (outValue));
        }

        ::nn::Result GetCertificates(const ::nn::sf::OutBuffer& outCertsData, ::nn::sf::Out<::std::uint32_t> outIdCount, const ::nn::sf::InBuffer& inCertIds) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCertificates, (outCertsData, outIdCount, inCertIds));
        }

        ::nn::Result GetCertificateBufSize(::nn::sf::Out<::std::uint32_t> outSize, const ::nn::sf::InBuffer& inCertIds) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCertificateBufSize, (outSize, inCertIds));
        }

        ::nn::Result DebugIoctl(const ::nn::sf::OutBuffer& outBufferInfo, const ::nn::sf::InBuffer& inBufferInfo, ::std::uint64_t cmd) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DebugIoctl, (outBufferInfo, inBufferInfo, cmd));
        }

        ::nn::Result SetInterfaceVersion(::std::uint32_t inValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetInterfaceVersion, (inValue));
        }

        ::nn::Result FlushSessionCache(::nn::sf::Out<::std::uint32_t> outEntriesDeletedCount, const ::nn::sf::InBuffer& pInHostNameBuf, ::nn::ssl::sf::FlushSessionCacheOptionType optionValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FlushSessionCache, (outEntriesDeletedCount, pInHostNameBuf, optionValue));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ISslService
    {
    public:
        nn::Result CreateContext(nn::sf::Out<nn::sf::SharedPointer<nn::ssl::sf::ISslContext>> outValue, nn::ssl::sf::SslVersion version, nn::Bit64 pid) NN_NOEXCEPT;
        nn::Result GetContextCount(nn::sf::Out<std::uint32_t> outValue) NN_NOEXCEPT;
        nn::Result GetCertificates(const nn::sf::OutBuffer& outCertsData, nn::sf::Out<std::uint32_t> outIdCount, const nn::sf::InBuffer& inCertIds) NN_NOEXCEPT;
        nn::Result GetCertificateBufSize(nn::sf::Out<std::uint32_t> outSize, const nn::sf::InBuffer& inCertIds) NN_NOEXCEPT;
        nn::Result DebugIoctl(const nn::sf::OutBuffer& outBufferInfo, const nn::sf::InBuffer& inBufferInfo, std::uint64_t cmd) NN_NOEXCEPT;
        nn::Result SetInterfaceVersion(std::uint32_t inValue) NN_NOEXCEPT;
        nn::Result FlushSessionCache(nn::sf::Out<std::uint32_t> outEntriesDeletedCount, const nn::sf::InBuffer& pInHostNameBuf, nn::ssl::sf::FlushSessionCacheOptionType optionValue) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CreateContext(nn::sf::Out<nn::sf::SharedPointer<nn::ssl::sf::ISslContext>> outValue, nn::ssl::sf::SslVersion version, nn::Bit64 pid) NN_NOEXCEPT;
    nn::Result GetContextCount(nn::sf::Out<std::uint32_t> outValue) NN_NOEXCEPT;
    nn::Result GetCertificates(const nn::sf::OutBuffer& outCertsData, nn::sf::Out<std::uint32_t> outIdCount, const nn::sf::InBuffer& inCertIds) NN_NOEXCEPT;
    nn::Result GetCertificateBufSize(nn::sf::Out<std::uint32_t> outSize, const nn::sf::InBuffer& inCertIds) NN_NOEXCEPT;
    nn::Result DebugIoctl(const nn::sf::OutBuffer& outBufferInfo, const nn::sf::InBuffer& inBufferInfo, std::uint64_t cmd) NN_NOEXCEPT;
    nn::Result SetInterfaceVersion(std::uint32_t inValue) NN_NOEXCEPT;
    nn::Result FlushSessionCache(nn::sf::Out<std::uint32_t> outEntriesDeletedCount, const nn::sf::InBuffer& pInHostNameBuf, nn::ssl::sf::FlushSessionCacheOptionType optionValue) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ssl::sf::ISslService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateContext, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ssl::sf::ISslContext>> outValue, ::nn::ssl::sf::SslVersion version, ::nn::Bit64 pid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateContext, (outValue, version, pid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetContextCount, (::nn::sf::Out<::std::uint32_t> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetContextCount, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCertificates, (const ::nn::sf::OutBuffer& outCertsData, ::nn::sf::Out<::std::uint32_t> outIdCount, const ::nn::sf::InBuffer& inCertIds))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCertificates, (outCertsData, outIdCount, inCertIds));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCertificateBufSize, (::nn::sf::Out<::std::uint32_t> outSize, const ::nn::sf::InBuffer& inCertIds))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCertificateBufSize, (outSize, inCertIds));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DebugIoctl, (const ::nn::sf::OutBuffer& outBufferInfo, const ::nn::sf::InBuffer& inBufferInfo, ::std::uint64_t cmd))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DebugIoctl, (outBufferInfo, inBufferInfo, cmd));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetInterfaceVersion, (::std::uint32_t inValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetInterfaceVersion, (inValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FlushSessionCache, (::nn::sf::Out<::std::uint32_t> outEntriesDeletedCount, const ::nn::sf::InBuffer& pInHostNameBuf, ::nn::ssl::sf::FlushSessionCacheOptionType optionValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FlushSessionCache, (outEntriesDeletedCount, pInHostNameBuf, optionValue));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ssl::sf::ISslService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ssl::sf::ISslService))

    // nn::Result CreateContext(nn::sf::Out<nn::sf::SharedPointer<nn::ssl::sf::ISslContext>> outValue, nn::ssl::sf::SslVersion version, nn::Bit64 pid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateContext)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(version, (::nn::ssl::sf::SslVersion), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (version, pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(version), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateContext)

    // nn::Result GetContextCount(nn::sf::Out<std::uint32_t> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetContextCount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetContextCount)

    // nn::Result GetCertificates(const nn::sf::OutBuffer& outCertsData, nn::sf::Out<std::uint32_t> outIdCount, const nn::sf::InBuffer& inCertIds) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCertificates)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outCertsData, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inCertIds, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outCertsData, inCertIds))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIdCount, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outIdCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCertsData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIdCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inCertIds)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCertificates)

    // nn::Result GetCertificateBufSize(nn::sf::Out<std::uint32_t> outSize, const nn::sf::InBuffer& inCertIds) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCertificateBufSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inCertIds, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (inCertIds))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inCertIds)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCertificateBufSize)

    // nn::Result DebugIoctl(const nn::sf::OutBuffer& outBufferInfo, const nn::sf::InBuffer& inBufferInfo, std::uint64_t cmd) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DebugIoctl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBufferInfo, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inBufferInfo, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outBufferInfo, inBufferInfo))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(cmd, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (cmd))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBufferInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBufferInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(cmd)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DebugIoctl)

    // nn::Result SetInterfaceVersion(std::uint32_t inValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetInterfaceVersion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(inValue, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (inValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetInterfaceVersion)

    // nn::Result FlushSessionCache(nn::sf::Out<std::uint32_t> outEntriesDeletedCount, const nn::sf::InBuffer& pInHostNameBuf, nn::ssl::sf::FlushSessionCacheOptionType optionValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FlushSessionCache)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pInHostNameBuf, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pInHostNameBuf))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(optionValue, (::nn::ssl::sf::FlushSessionCacheOptionType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (optionValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outEntriesDeletedCount, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outEntriesDeletedCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outEntriesDeletedCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pInHostNameBuf), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(optionValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FlushSessionCache)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ssl::sf::ISslService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ssl::sf::ISslService))

    // nn::Result CreateContext(nn::sf::Out<nn::sf::SharedPointer<nn::ssl::sf::ISslContext>> outValue, nn::ssl::sf::SslVersion version, nn::Bit64 pid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateContext, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ssl::sf::ISslContext>> outValue, ::nn::ssl::sf::SslVersion version, ::nn::Bit64 pid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(version)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateContext)
    }

    // nn::Result GetContextCount(nn::sf::Out<std::uint32_t> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetContextCount, (::nn::sf::Out<::std::uint32_t> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetContextCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetContextCount)
    }

    // nn::Result GetCertificates(const nn::sf::OutBuffer& outCertsData, nn::sf::Out<std::uint32_t> outIdCount, const nn::sf::InBuffer& inCertIds) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCertificates, (const ::nn::sf::OutBuffer& outCertsData, ::nn::sf::Out<::std::uint32_t> outIdCount, const ::nn::sf::InBuffer& inCertIds))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCertificates)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCertsData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIdCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inCertIds)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCertificates)
    }

    // nn::Result GetCertificateBufSize(nn::sf::Out<std::uint32_t> outSize, const nn::sf::InBuffer& inCertIds) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCertificateBufSize, (::nn::sf::Out<::std::uint32_t> outSize, const ::nn::sf::InBuffer& inCertIds))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCertificateBufSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inCertIds)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCertificateBufSize)
    }

    // nn::Result DebugIoctl(const nn::sf::OutBuffer& outBufferInfo, const nn::sf::InBuffer& inBufferInfo, std::uint64_t cmd) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DebugIoctl, (const ::nn::sf::OutBuffer& outBufferInfo, const ::nn::sf::InBuffer& inBufferInfo, ::std::uint64_t cmd))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DebugIoctl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBufferInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBufferInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(cmd)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DebugIoctl)
    }

    // nn::Result SetInterfaceVersion(std::uint32_t inValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetInterfaceVersion, (::std::uint32_t inValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetInterfaceVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetInterfaceVersion)
    }

    // nn::Result FlushSessionCache(nn::sf::Out<std::uint32_t> outEntriesDeletedCount, const nn::sf::InBuffer& pInHostNameBuf, nn::ssl::sf::FlushSessionCacheOptionType optionValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FlushSessionCache, (::nn::sf::Out<::std::uint32_t> outEntriesDeletedCount, const ::nn::sf::InBuffer& pInHostNameBuf, ::nn::ssl::sf::FlushSessionCacheOptionType optionValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FlushSessionCache)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outEntriesDeletedCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pInHostNameBuf)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(optionValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FlushSessionCache)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ssl::sf::ISslService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ssl::sf::ISslService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ssl::sf::ISslContext>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateContext)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(version),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetContextCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetContextCount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCertificates)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outCertsData)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inCertIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCertificates)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outCertsData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIdCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inCertIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCertificateBufSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inCertIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCertificateBufSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inCertIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DebugIoctl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBufferInfo)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inBufferInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DebugIoctl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBufferInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inBufferInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(cmd)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetInterfaceVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetInterfaceVersion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(inValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FlushSessionCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pInHostNameBuf)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FlushSessionCache)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outEntriesDeletedCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pInHostNameBuf),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(optionValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetContextCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCertificates)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCertificateBufSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DebugIoctl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetInterfaceVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FlushSessionCache)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ssl::sf::ISslService))
